/* -*-c++-*-
=========================================================================
=                                                                       =
=                                GL_OBJECT.CC                           =
=                                                                       =
=========================================================================

comment here

Target: VxWorks/UNIX/Generic

Designed by:    Chris Urmson
Written by:     Chris Urmson
Date:           June 2002

Copyright 2002 Carnegie Mellon University
$Author: jayg $
$Date: 2004/04/26 19:58:42 $
$Header: /IUS/jeep/cvsroot/ModUtils/GLUtils/gl_object.cc,v 1.1 2004/04/26 19:58:42 jayg Exp $
$Id: gl_object.cc,v 1.1 2004/04/26 19:58:42 jayg Exp $
$Log: gl_object.cc,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.2  2003/11/09 19:48:36  mkj
fixed Fl GL init incompatiblities

Revision 1.1  2003/09/06 22:25:04  curmson
First commit of gl utils in this working directory structure.

Revision 1.1  2003/02/25 14:18:39  curmson
First commit of the new gl_utils library.  This code is somewhat cleaner than the old glHelpers code and is more powerful.

It supports new features including:
        multiple windows
        lighting
        object registration
        ability to set z up or z down orientation

Revision 1.2  2002/07/01 21:59:23  curmson
Added more comments and restructured initialization to avoid some warning messages on certain systems.

Revision 1.1  2002/06/26 01:01:18  curmson
This is a first commit of the util_open_gl module.  It provides a simplified interface to glut and the openGL, and simplifies the task of creating a quick debugging UI.



 ------------------------------------------------------------------------*/
#include <GL/gl.h>
#include <GL/glut.h>
#include "gl_object.h"

/*************************************************
 * Common Object functions                       *
 ************************************************/


void GL_Object::draw(void) {
  if (_should_draw==false) 
    return;
  glPushMatrix();
  glTranslated(_location.x,_location.y,_location.z);
  draw_object(); 
  glPopMatrix();
}

GL_Display_List_Object::GL_Display_List_Object(void) {
  _display_list = glGenLists(1);
}

void GL_Display_List_Object::draw_object(void) {
  glCallList(_display_list);
}

void GL_Origin::draw_object(void) {
  bool lighting_on=false;
  if (glIsEnabled(GL_LIGHTING)) {
    lighting_on=true;
    glDisable(GL_LIGHTING);
  }

  glColor3f(1.0,0.0,0.0); 

  glBegin(GL_LINES); {
    glVertex3f(0,0,0);
    glVertex3f(_length,0,0);
    glColor3f(0.0,1.0,0.0);
    glVertex3f(0,0,0);
    glVertex3f(0,_length,0);
    glColor3f(0.0,0.0,1.0);
    glVertex3f(0,0,0);
    glVertex3f(0,0,_length);
  } glEnd();
  if (lighting_on)
    glEnable(GL_LIGHTING);
}


GL_Hash::GL_Hash(float size, float R, float G, float B) {
  this->_size =size; 
  this->_R=R;
  this->_G=G;
  this->_B=B;
  _s2=size/2;
}

void GL_Hash::draw_object(void) {
  bool lighting_on=false;
  if (glIsEnabled(GL_LIGHTING)) {
    lighting_on=true;
    glDisable(GL_LIGHTING);
  }

  glColor3f(_R,_G,_B);
  glBegin(GL_LINES); {
    glVertex3f(-_s2,0,0);
    glVertex3f(_s2,0,0);
    glVertex3f(0,-_s2,0);
    glVertex3f(0,_s2,0);
    glVertex3f(0,0,-_s2);
    glVertex3f(0,0,_s2);
  } glEnd();
  if (lighting_on)
    glEnable(GL_LIGHTING);
    
}


GL_Ground_Plane::GL_Ground_Plane(float lineSpacing,int numCells,
                                 float R, float G, float B) {
  this->_R = R;
  this->_G = G;
  this->_B = B;
  this->_lineSpacing = lineSpacing;
  this->_numCells = numCells;
}
void GL_Ground_Plane::draw_object(void) {
  bool lighting_on=false;
  if (glIsEnabled(GL_LIGHTING)) {
    lighting_on=true;
    glDisable(GL_LIGHTING);
  }

  int i;
  glBegin(GL_LINES); {
    for (i=-_numCells/2;i<_numCells/2+1;i++) { 
      glColor3f(_R,_G,_B); 
      if ((i+_numCells)%4==0)
        glColor3f(1-_R,1-_G,1-_B);
      glVertex3f(i*_lineSpacing,-_lineSpacing*_numCells/2,0);
      glVertex3f(i*_lineSpacing,_lineSpacing*_numCells/2,0);
      glVertex3f(-_lineSpacing*_numCells/2,i*_lineSpacing,0);
      glVertex3f(_lineSpacing*_numCells/2,i*_lineSpacing,0);
    }
  } glEnd();

  if (lighting_on)
    glEnable(GL_LIGHTING);
}

