/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_TexturedHeightMap.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION: This file contains a class to draw a texture mapped height field.

*/
/*REVISION HISTORY

$Log: GL_TexturedHeightMap.h,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.2  2003/11/17 05:26:17  curmson
Added a second render call, allowing the user to pass a double array instead of just an integer array.

Revision 1.1  2003/11/17 05:19:36  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_TEXTUREDHEIGHTMAP_H
#define GL_TEXTUREDHEIGHTMAP_H
#include <GLUtils/GL_TextureMap.h>

class GL_TexturedHeightMap: public GL_TextureMap {
public:
  GL_TexturedHeightMap(void): GL_TextureMap() {};

  /**
     This will render to a texture mapped height field in world space the 
     pixmap (packed RGB format) passed in data.

     pixWidth, pixLength- the dimensions of the RGB image (in pixels)

     data- the pixel values in packed RGB format

     elevWidth, elevLength- the dimensions of the height field (in postings)

     heights- an array of elevation data 

     postingStepX, postingStepY- the distance for row and column steps in the 
     height array.

     hScaling- a value to multiply each height by to convert the value to units

     topLeft- the location in world space where the top left corner of the 
     image and height map should be drawn.

     width,length- the size of the data in world space units

     returns true if the texture could be rendered, false otherwise
*/
  bool render(int pixWidth, int pixLength, unsigned char *data,
	      int elevWidth, int elevLength, int * heights,
	      double postingStepX, double postingStepY, double hScaling,
	      r3Vector topLeft, double width, double length);

  /**
     same as above, but assumes a prescaled height array of doubles*/
  bool render (int pixWidth, int pixLength, unsigned char *data,
	      int elevWidth, int elevLength, double * heights,
	      double postingStepX, double postingStepY,
	      r3Vector topLeft, double width, double length);


};


#endif //ifndef GL_TEXTUREDHEIGHTMAP_H
