/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_TexturedHeightMap.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: GL_TexturedHeightMap.cc,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.2  2003/11/17 05:26:17  curmson
Added a second render call, allowing the user to pass a double array instead of just an integer array.

Revision 1.1  2003/11/17 05:19:36  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_TEXTUREDHEIGHTMAP_CC
#define GL_TEXTUREDHEIGHTMAP_CC
#include <GLUtils/GL_TexturedHeightMap.h>

bool GL_TexturedHeightMap::render(
  int pixWidth, int pixLength, unsigned char *data,
  int elevWidth, int elevLength, int * heights,
  double postingStepX, double postingStepY, double hScaling,
  r3Vector topLeft, double width, double length) {

  // try and copy the texture into memory
  if(!copyTexture(pixWidth,pixLength,data)) {
    return false;
  }
  
  // setup parameters
  double texStepX, texStepY, texX,texY;
  double x,y;
  int r,c;

  texStepX = postingStepX/width *pixWidth/(1.0*MAX_TEXTURE_DIM);
  texStepY = postingStepY/length *pixLength/(1.0*MAX_TEXTURE_DIM);

  start_list(); {
    glEnable(GL_TEXTURE_2D);
    glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);

    /* generate a set of strips that are parallel to the x axis*/
    for (r=0,y=topLeft.y, texY=0;
	 r<elevLength-1;
	 r++,y+=postingStepY,texY+=texStepY) {

      glBegin(GL_TRIANGLE_STRIP); {
	for (c=0, x= topLeft.x, texX=0;
	     c<elevWidth-1;
	     c++,x+=postingStepX, texX+=texStepX) {
	  /* generate the texture coordinates and verticies for this row*/
	  glTexCoord2d(texX,texY);
	  glVertex3f(x,y,heights[c+r*elevWidth]*hScaling);
	  /* and the next row*/
	  glTexCoord2d(texX,texY+texStepY);
	  glVertex3f(x,y+postingStepY,heights[c+(r+1)*elevWidth]*hScaling);

	}
      } glEnd();
    }

    glDisable(GL_TEXTURE_2D);
  } end_list();

  return true;
}


bool GL_TexturedHeightMap::render(
  int pixWidth, int pixLength, unsigned char *data,
  int elevWidth, int elevLength, double * heights,
  double postingStepX, double postingStepY,
  r3Vector topLeft, double width, double length) {

  // try and copy the texture into memory
  if(!copyTexture(pixWidth,pixLength,data)) {
    return false;
  }
  
  // setup parameters
  double texStepX, texStepY, texX,texY;
  double x,y;
  int r,c;

  texStepX = postingStepX/width *pixWidth/(1.0*MAX_TEXTURE_DIM);
  texStepY = postingStepY/length *pixLength/(1.0*MAX_TEXTURE_DIM);

  start_list(); {
    glEnable(GL_TEXTURE_2D);
    glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);

    /* generate a set of strips that are parallel to the x axis*/
    for (r=0,y=topLeft.y, texY=0;
	 r<elevLength-1;
	 r++,y+=postingStepY,texY+=texStepY) {

      glBegin(GL_TRIANGLE_STRIP); {
	for (c=0, x= topLeft.x, texX=0;
	     c<elevWidth-1;
	     c++,x+=postingStepX, texX+=texStepX) {
	  /* generate the texture coordinates and verticies for this row*/
	  glTexCoord2d(texX,texY);
	  glVertex3d(x,y,heights[c+r*elevWidth]);
	  /* and the next row*/
	  glTexCoord2d(texX,texY+texStepY);
	  glVertex3d(x,y+postingStepY,heights[c+(r+1)*elevWidth]);

	}
      } glEnd();
    }

    glDisable(GL_TEXTURE_2D);
  } end_list();

  return true;
}


#endif //ifndef GL_TEXTUREDHEIGHTMAP_CC
