/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_TextureMap.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: GL_TextureMap.cc,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.1  2003/11/17 05:19:36  curmson
Added a number of objects for rendering texture mapped stuff.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_TEXTUREMAP_CC
#define GL_TEXTUREMAP_CC
#include <GLUtils/GL_TextureMap.h>

GL_TextureMap::GL_TextureMap(void) {
  glGenTextures(1,(GLuint*)&_texId);
  glBindTexture(GL_TEXTURE_2D,_texId);
  glPixelStorei(GL_UNPACK_ALIGNMENT,1);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T, GL_REPEAT);

 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
 
 glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, MAX_TEXTURE_DIM,MAX_TEXTURE_DIM,0 , 
                 GL_RGB, GL_UNSIGNED_BYTE,NULL);

 _img = new unsigned char[MAX_TEXTURE_DIM*MAX_TEXTURE_DIM*3];
 glTexSubImage2D(GL_TEXTURE_2D, 0, 0,0, MAX_TEXTURE_DIM,MAX_TEXTURE_DIM ,
                 GL_RGB, GL_UNSIGNED_BYTE,_img);

}

GL_TextureMap::~GL_TextureMap() {
  delete[] _img;
}

bool GL_TextureMap::render(int pixWidth, int pixLength, unsigned char *data,
                          r3Vector topLeft, double width, double length) {
  double perW, perL; // percentage of the full texture that pixWidth and pixLength take up

 // try and copy the texture into memory
  if(!copyTexture(pixWidth,pixLength,data)) {
    return false;
  }

  //figure out our percent drawn...
  perW = pixWidth/(1.0*MAX_TEXTURE_DIM);
  perL = pixLength/(1.0*MAX_TEXTURE_DIM);

  //now draw our quadrangle
  start_list(); {
    glEnable(GL_TEXTURE_2D);
    glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_REPLACE);
    glBegin(GL_QUADS); {
      glTexCoord2d(0,0);
      glVertex3d(topLeft.x,topLeft.y,topLeft.z);

      glTexCoord2d(perW,0);
      glVertex3d(topLeft.x+width,topLeft.y,topLeft.z);

      glTexCoord2d(perW,perL);
      glVertex3d(topLeft.x+width,topLeft.y-length,topLeft.z);

      glTexCoord2d(0,perL);
      glVertex3d(topLeft.x,topLeft.y-length,topLeft.z);

    } glEnd();
    glDisable(GL_TEXTURE_2D);
  } end_list();
  return true;
}

bool GL_TextureMap::copyTexture(int pixWidth, int pixLength, unsigned char *data) {

// check to make sure the image isn't too big.
  if (pixWidth> MAX_TEXTURE_DIM || pixLength > MAX_TEXTURE_DIM) {
    // LOGERROR("image data is too large to render");
    return false;
  }

  // now we copy the texture memory across
  int r;
  unsigned char *dest = _img;
  unsigned char *src = data;
  // copy the data from the passed pixel buffer into our texture buffer
  for (r=0;r<pixLength;r++,dest+=MAX_TEXTURE_DIM*3, src+=pixWidth*3) {
    memcpy(dest,src,pixWidth*3);
  }

 // tell openGL that our buffer has changed
  glTexSubImage2D(GL_TEXTURE_2D,0,0,0,MAX_TEXTURE_DIM,MAX_TEXTURE_DIM,
                  GL_RGB, GL_UNSIGNED_BYTE,_img);
  return true;
}


#endif //ifndef GL_TEXTUREMAP_CC
