/* $Revision: 1.2 $

$Date: 2004/04/27 18:35:41 $

$Author: jayg $*/
/** @file GL_PointList.h

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: GL_PointList.h,v $
Revision 1.2  2004/04/27 18:35:41  jayg
Tweaked for demo

Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.5  2004/01/20 04:25:23  curmson
Made GL_Pointlist a templatized class

Revision 1.4  2004/01/08 21:48:37  redteam
Added flag to set flat drawing of 3d data.

Revision 1.3  2004/01/07 11:01:05  jgowdy
Add accessor for deque's of points

Revision 1.2  2003/11/17 01:59:54  wjh
include <vector>; namespace std <<BLETCH -wjh>>

Revision 1.1  2003/11/11 08:13:33  curmson
Added code for some gl_object primitive types.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_POINTLIST_H
#define GL_POINTLIST_H
#include <vector>
#include <deque>
using namespace std;
#include <GLUtils/gl_object.h>

template <class PtType>
class GL_PointListBase: public GL_Display_List_Object {

public:
  GL_PointListBase(void) {};
  
  void render_path(vector<PtType> pts, float r, float g, float b,float thickness=1, bool flat = false) {
    typename vector<PtType>::iterator it;
    start_list(); {
      glColor3f(r,g,b);
      glLineWidth(thickness);
      glBegin(GL_LINE_STRIP); {
	for (it = pts.begin();it!=pts.end();it++) {
	  if (!flat)
	    glVertex3f(it->x,it->y,it->z);
	  else 
	    glVertex3f(it->x,it->y,0);
	}
      } glEnd();
      glLineWidth(1.0);
    } end_list();
  };


  void render_path(vector<PtType> pts, vector<PtType> cols,float thickness=1, bool flat = false) {
    typename vector<PtType>::iterator it, colit;
    start_list(); {
      glLineWidth(thickness);
      glBegin(GL_LINE_STRIP); {
	for (it = pts.begin(), colit = cols.begin();it!=pts.end();it++, colit++) {
	  glColor3f(colit->x,colit->y,colit->z);

	  if (!flat)
	    glVertex3f(it->x,it->y,it->z);
	  else 
	    glVertex3f(it->x,it->y,0);
	}
      } glEnd();
      glLineWidth(1.0);
    } end_list();
  };


  void render_points(vector<PtType> &pts, float r, float g, float b,float thickness=1) {
    typename vector<PtType>::iterator it;
    start_list(); {
      glColor3f(r,g,b);
      glPointSize(thickness);
      glBegin(GL_POINTS); {
	for (it = pts.begin();it!=pts.end();it++) {
	  glVertex3f(it->x,it->y,it->z);
	}
      } glEnd();
      glPointSize(1.0);
    } end_list();
  };


  void render_points(vector<PtType> &pts, vector<PtType> &cols,float thickness=1) {
    typename vector<r3Vector>::iterator it;
    typename vector<r3Vector>::iterator colit;
    start_list(); {
      glPointSize(thickness);
      glBegin(GL_POINTS); {
	for (it = pts.begin(), colit = cols.begin();it!=pts.end();it++,colit++) {
          glColor3f(colit->x, colit->y, colit->z);
	  glVertex3f(it->x,it->y,it->z);
	}
      } glEnd();
      glPointSize(1.0);
    } end_list();
  };


  void render_points(deque<PtType> &pts, float r, float g, float b,float thickness=1) {
    typename deque<r3Vector>::iterator it;
    start_list(); {
      glColor3f(r,g,b);
      glPointSize(thickness);
      glBegin(GL_POINTS); {
	for (it = pts.begin();it!=pts.end();it++) {
	  glVertex3f(it->x,it->y,it->z);
	}
      } glEnd();
      glPointSize(1.0);
    } end_list();
  };

};


typedef GL_PointListBase<r3Vector> GL_PointList;

#endif //ifndef GL_POINTLIST_H
