/* $Revision: 1.1 $

$Date: 2004/04/26 19:58:42 $

$Author: jayg $*/
/** @file GL_Lozenge.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: GL_Lozenge.cc,v $
Revision 1.1  2004/04/26 19:58:42  jayg
First version of GLUtils ripped from Redteam

Revision 1.2  2003/11/29 16:59:45  curmson
Added installation of lozenge header and removed a print out

Revision 1.1  2003/11/28 05:51:14  curmson
Added code to draw lozenges (i.e. waypoint corridors) and added a couple of macros to simplify using r3Vector with GL code.


(c) Copyright 2003 CMU. All rights reserved.
*/
#ifndef GL_LOZENGE_CC
#define GL_LOZENGE_CC
#include <GLUtils/GL_Lozenge.h>

void GL_Lozenge::renderLozenge(r3Vector a, r3Vector b, double radius) {
  // generate the basis vectors for our quadrangle
  r3Vector dX,dY;
  dX = b-a;
  dY = b-a;
  dY.rotateZ(M_PI/2);
  dY.normalize(); dY*=radius;
  start_list(); {
    // setup the quadric -used for drawing round things...
    GLUquadricObj *obj = gluNewQuadric();
    if (_fill)
      gluQuadricDrawStyle(obj, GLU_FILL);
    else 
      gluQuadricDrawStyle(obj, GLU_SILHOUETTE);
    gluQuadricNormals(obj, GLU_SMOOTH);
    gluQuadricOrientation(obj, GLU_OUTSIDE);
    glColor4f(_r,_g,_bl,_alpha);
    // draw the two disks...
    glPushMatrix(); {
      glTranslateR3(a);
      gluDisk(obj,0,radius,20,1);
    } glPopMatrix();
    glPushMatrix(); {
      glTranslateR3(b);
      gluDisk(obj,0,radius,20,1);
    } glPopMatrix();
    
    if (_fill) {
      glBegin(GL_QUADS); {
	glVertexR3(a+dY);
	glVertexR3(a+dY+dX);
	glVertexR3(a-dY+dX);
	glVertexR3(a-dY);
      } glEnd();
    } else {
      glBegin(GL_LINES); {
	glVertexR3(a+dY);
	glVertexR3(a+dY+dX);
	glVertexR3(a-dY);
	glVertexR3(a-dY+dX);
      } glEnd();
    }

    gluDeleteQuadric(obj);    
  } end_list();
}



#endif //ifndef GL_LOZENGE_CC
