#ifndef _FAKE_GL_H
#define _FAKE_GL_H

/*
 * OpenGL fake routines/definitions.  This is not comprehensive, just what
 * I've run across so far.  If you're coming up with something undefined when you
 * stub out the display code, add it here.
 */
typedef unsigned int   GLuint;
typedef int            GLsizei;
typedef int            GLint;
typedef void           GLvoid;
typedef signed char    GLbyte;
typedef double         GLdouble;
typedef float          GLfloat;
typedef short          GLshort;
typedef unsigned char  GLubyte;
typedef unsigned short GLushort;

enum GLenum {
        GL_SMOOTH,
        GL_NO_ERROR,
        GL_TEXTURE_2D,
        GL_TEXTURE_WRAP_S,
        GL_TEXTURE_WRAP_T,
        GL_TEXTURE_MAG_FILTER,
        GL_TEXTURE_MIN_FILTER,
        GL_RGBA,
        GL_UNSIGNED_BYTE,
        GL_NEAREST,
        GL_REPEAT,
        GL_BLEND,
        GL_SRC_ALPHA,
        GL_ONE_MINUS_SRC_ALPHA,
        GL_MODELVIEW,
        GL_QUADS,
        GL_POINTS,
        GL_FLOAT,
        GL_LINES,
        GL_VERTEX_ARRAY
};

typedef unsigned char GLboolean; 

static inline void      glShadeModel(GLenum a) {}
static inline GLenum    glGetError() {return GL_NO_ERROR;}
static inline void      glGenTextures(GLsizei n,GLuint *textures) {}
static inline void      glBindTexture(GLenum target, GLuint texture) {}
static inline GLboolean glIsTexture(GLuint texture) { return 1; }
static inline void      glTexParameteri(GLenum target, GLenum pname, GLint param) {}
static inline void      glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width,
                                     GLsizei height, GLint border, GLenum format, GLenum type,
                                     const GLvoid *pixels) {}
static inline void      glEnable(GLenum cap) {}
static inline void      glDisable(GLenum cap) {}
static inline void      glBlendFunc(GLenum sfactor, GLenum dfactor) {}
static inline void      glMatrixMode(GLenum mode) {}
static inline void      glColor3b(GLbyte red, GLbyte green, GLbyte blue) {}
static inline void      glColor3d(GLdouble red, GLdouble green, GLdouble blue) {}
static inline void      glColor3f(GLfloat red, GLfloat green, GLfloat blue) {}
static inline void      glColor3i(GLint red, GLint green, GLint blue) {}
static inline void      glColor3s(GLshort red, GLshort green, GLshort blue) {}
static inline void      glColor3ub(GLubyte red, GLubyte green, GLubyte blue) {}
static inline void      glColor3ui(GLuint red, GLuint green, GLuint blue) {}
static inline void      glColor3us(GLushort red, GLushort green, GLushort blue) {}
static inline void      glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha) {}
static inline void      glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha) {}
static inline void      glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha) {}
static inline void      glColor4i(GLint red, GLint green, GLint blue, GLint alpha) {}
static inline void      glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha) {}
static inline void      glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha) {}
static inline void      glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha) {}
static inline void      glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha) {}
static inline void      glPushMatrix() {}
static inline void      glPopMatrix() {}
static inline void      glTranslated(GLdouble x, GLdouble y, GLdouble z) {}
static inline void      glTranslatef(GLfloat x, GLfloat y, GLfloat z) {}
static inline void      glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z) {}
static inline void      glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z) {}
static inline void      glTexCoord1d(GLdouble s) {}
static inline void      glTexCoord1f(GLfloat s) {}
static inline void      glTexCoord1i(GLint s) {}
static inline void      glTexCoord1s(GLshort s) {}
static inline void      glTexCoord2d(GLdouble s,  GLdouble t) {}
static inline void      glTexCoord2f(GLfloat s, GLfloat t) {}
static inline void      glTexCoord2i(GLint s, GLint t) {}
static inline void      glTexCoord2s(GLshort s, GLshort t) {}
static inline void      glTexCoord3d(GLdouble s, GLdouble t, GLdouble r) {}
static inline void      glTexCoord3f(GLfloat s, GLfloat t, GLfloat r) {}
static inline void      glTexCoord3i(GLint s, GLint t, GLint r) {}
static inline void      glTexCoord3s(GLshort s, GLshort t, GLshort r) {}
static inline void      glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q) {}
static inline void      glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q) {}
static inline void      glTexCoord4i(GLint s, GLint t, GLint r, GLint q) {}
static inline void      glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q) {}
static inline void      glBegin(GLenum mode) {}
static inline void      glEnd(void) {}
static inline void      glVertex2d(GLdouble x, GLdouble y) {}
static inline void      glVertex2f(GLfloat x, GLfloat y) {}
static inline void      glVertex2i(GLint x, GLint y) {}
static inline void      glVertex2s(GLshort x, GLshort y) {}
static inline void      glVertex3d(GLdouble x, GLdouble y, GLdouble z) {}
static inline void      glVertex3f(GLfloat x, GLfloat y, GLfloat z) {}
static inline void      glVertex3i(GLint x, GLint y, GLint z) {}
static inline void      glVertex3s(GLshort x, GLshort y, GLshort z) {}
static inline void      glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w) {}
static inline void      glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w) {}
static inline void      glVertex4i(GLint x, GLint y, GLint z, GLint w) {}
static inline void      glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w) {}
static inline void      glDrawArrays(GLenum mode, GLint first, GLsizei count) {}
static inline void      glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer) {}
static inline void      glEnableClientState(GLenum array) {}
static inline void      glDisableClientState(GLenum array) {}
static inline GLboolean glIsEnabled(GLenum cap) { return 1; }

#endif
