#ifndef _FAKE_DISPLAY_H
#define _FAKE_DISPLAY_H

#include <utils/SymbolTable.h>
#include <utils/ConfigFile.h>
#include <iostream.h>
#include <stdlib.h>
#include <FL/Fl.H>
#include <Fl/Fl_Double_Window.H>

class Display : public Fl_Double_Window
{
 public:
        Display(const char *spec,
                utils::SymbolTable *globals) 
                : Fl_Double_Window(0, 0) {
                _complain();
        }
        
        /*
         * Create a display manually
         */
        Display(int w, int h,
                const char *name,
                bool track_vehicle_pos = false,/* Does the display track the vehicle position? */
                bool track_vehicle_rot = false,/* Does the display track the vehicle rotation? */
                bool enable_mouse_move = true, /* Can the user move the display with the mouse? */
                bool enable_zoom = true)      /* Can the user zoom in/out with the mouse?      */
                : Fl_Double_Window(0, 0) {
                _complain();
        }


        virtual ~Display() {}

        void set_easting_window(double new_window) {}
        void set_northing_window(double new_window) {}
        void set_center(double new_easting, double new_northing) {}
        void set_veh_pos(double easting, double northing, double yaw, double e_o = 0, double n_o = 0, double y_o = 0) {}
        void set_smooth_offset(double x_offset, double y_offset, double heading_offset) {}
        void mouse_moveable(bool state) {}
        void mouse_zoomable(bool state) {}
        bool mouse_is_moveable()        { return false; }
        bool mouse_is_zoomable()        { return false;  }
        void track_veh_pos(bool state) {}
        void track_veh_rot(bool state) {}
        bool is_tracking_veh_pos()     { return false;  }
        bool is_tracking_veh_rot()     { return false;  }

        void set_global_origin_offset(double easting_offset, double northing_offset) {}

        void add_callback(void (*fn)(double easting_origin, double northing_origin,
                                     double low_easting, double low_northing, double high_easting, double high_northing, utils::SymbolTable *st, void *data),
                          int priority,
                          DisplayCoordFrame frame,
                          void *data) {}
        static void setup(void (*fn)(double e_o, double n_o, double a, double b, double c, double d, utils::SymbolTable *s, void *e),
                          int d,
                          DisplayCoordFrame frame,
                          void *ptr, utils::ConfigFile *params, utils::SymbolTable *globals) {}
 private:
        void _complain() {
                cerr << "Display code has been stubbed out, but an attempt was made to create a display!" << endl;
                exit(-1);
        }
};


#endif
