#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#include <stdio.h>

#include <utils/String.h>
#include <utils/ConfigFile.h>
#include <utils/Output.h>
#include <ConfigSource/Module.h>
#include <ConfigSource/ConfigSource.h>
#include <CannedVideo/CannedVideo.h>

class SX12CollectModule : public Module
{
public:
  SX12CollectModule(const char* spec) : Module("ImageGrabber", spec)
  {
    _started = false;
  }
  ~SX12CollectModule()
  {
    if (_started) {
      printf("Shutting down MPEG collection\n");
      _writer.stop_sx12();
    }
  }

  virtual bool initialize(ConfigSource* config, utils::SymbolTable* table)
  {
    const char* file_name = config->getString("name", "Movie.ram");
    const char* dev_name = config->getString("device", "/dev/sx12a");
    int bit_rate = config->getInt("bit_rate", 2000000);
    int frame_rate = config->getInt("frame_rate", 30);

    try {
      _writer.open_sx12(dev_name, file_name, bit_rate, frame_rate);
      _writer.writeDescription("MPEG from SX12");
      utils::ConfigFile header;
      header.setInt("int num_rows", 480);
      header.setInt("int num_cols", 640);
      header.setString("string name", file_name);
      header.setString("string device", dev_name);
      header.setInt("int bit_rate", bit_rate);
      header.setInt("int frame_rate", frame_rate);

      char* buffer = new char[200];
      utils::Output output;
      output.setBuffer(buffer, 200, utils::Output::standardResize);
      header.write(output);
      output.write('\0');
      void* out_buf;
      int size;
      output.getBuffer(out_buf, size);
      _writer.writeHeader(out_buf, size);
      delete [] (char*) out_buf;

      _writer.start_sx12();
    } catch (utils::CannedDataError err) {
      utils::String errMsg;
      errMsg = err.getMsg();
      fprintf(stderr, "Ack!: %s\n", errMsg.getString());
      return false;
    }

    printf("Starting MPEG collection\n");

    _started = true;
    _interval = config->getFloat("interval", 0.05);

    return true;
  }

  virtual bool run() {
    getConfigSource()->processEvents(_interval);
    return true;
  }

private:
  utils::CannedVideoWriter _writer;
  float _interval;
  bool _started;
};

MODULE_MAIN(sx12_collect, SX12CollectModule);
