# define ARRAY 257
# define BOX 258
# define END 259
# define GTGT 260
# define LABEL 261
# define LABELS 262
# define LTLT 263
# define NUMBER 264
# define POSITIONER 265
# define RECT 266
# define SIGN 267
# define TECH 268
# define TRANSFORM 269
# define USE 270
# define WORD 271

# line 19 "y.spec"
# include "options.h"
# include <stdio.h>
# include "assert.h"
# include <ctype.h>
# include "macros.h"
# include "index.h"

# ifndef	lint
	static	char	yspecSccsid[] = "%W% %G%";
# endif	lint

# ifdef GRAPHICS
#	define UNIX
#	include "/jb/ingres/toni/cad/lib/mfb.h"
# endif

/* character types */
# define LETTER		1001
# define DIGIT		1002
# define WHITESPACE		1003

struct layertab
{
	char *name;
	char *letter;
};

struct
{
	char *string;
	int token;
} Keywords[] =
{
	"array",	ARRAY,
	"box",		BOX,
	"end",		END,
	">>",		GTGT,
	"<<",		LTLT,
	"labels",	LABELS,
	"label",	LABEL,
	"positioner",	POSITIONER,
	"rect",		RECT,
	"tech",		TECH,
	"transform",	TRANSFORM,
	"use",		USE,
	NULL,		0
};

struct layertab Layers[] =
{
	"polysilicon",		"p",
	"diffusion",		"d",
	"metal",		"m",
	"implant",		"i",
	"buried_contact",	"b",
	"cut",			"c",
	"overglass",		"o",
	"errors",		"e",
	"all",			"-",
	NULL,			0
};

FILE *Infile;
char Layer[30], Technology[20];
int tokenval;
char Tokenstring[80], label[20], subname[20];
int x1, y1, x2, y2, side, t[3][2];
int axlo, axhi, axsep, aylo, ayhi, aysep;

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 187 "y.spec"
 /* programs section */

/* derived from scan.c	1.4 6/22/82 */

yylex()
{
	int c, c_type, token_type, lim;
	char *w;

	w = Tokenstring;
	while ((c_type = type(c = getc(Infile))) == WHITESPACE)
		;
	*w++ = c;

	switch (c_type)
	{
	case '+':
	case '-':
		token_type = SIGN;
		break;
	case DIGIT:
		token_type = NUMBER;
		break;
	case EOF:
		*w = '\0';
		return EOF;
	default:
		token_type = WORD;
		break;
	}

	lim = 80;
	while (--lim > 0)
	{
		c_type = type(c = *w++ = getc(Infile));
		if (c_type == WHITESPACE || c == EOF)
		{
			*--w = '\0';
			if (token_type == WORD)
				return (checkword(Tokenstring));
			else if (token_type == NUMBER)
			{
				/* evaluate number string */
				sscanf(Tokenstring, "%ld", &tokenval);
				return (NUMBER);
			}
			else
				return (token_type);
		}
		else if (token_type == NUMBER && c_type != DIGIT)
			token_type = WORD;
		else if (token_type == SIGN)
		{
			if (c_type == DIGIT)
				token_type = NUMBER;
			else
				token_type = WORD;
		}
	}
	error("scan: token too long");
	return (EOF);
}

type(c)		/* return type of ascii character */
int c;
{
	if (isspace(c))
		return(WHITESPACE);
	else if (isalpha(c))
		return(LETTER);
	else if (isdigit(c))
		return(DIGIT);
	else
		return(c);
}

int
checkword(w)
char *w;
{
	int i;
	char *s;

	for (i = 0; (s = Keywords[i].string) != NULL; i++)
	{
		if (!strcmp(w, s))
			return (Keywords[i].token);
	}
	return(WORD);
}


yyerror(string)
char *string;
{
#	ifdef GRAPHICS
		EndGraphics();
#	endif
	Tokenstring[79] = '\0';
	fflush(stdout);
	fprintf(stderr, "Error: %s token=\"%s\"\n", string, Tokenstring);
	fflush(stderr);
}


getlayer(n)
char *n;
{
	int i;
	char *s;

	for (i = 0; (s = Layers[i].name) != NULL; i++)
	{
		if (!strcmp(n, s))
		{
			strcpy(Layer, Layers[i].letter);
			return;
		}
	}
#	ifdef GRAPHICS
		EndGraphics();
#	endif
	error("getlayer: layer name not found");
}

ProcessBox(x1, y1, x2, y2)
int x1, y1, x2, y2;
{
	static int flag=0, count=0, result;
	int tid;
	struct Rect r;

	if (x1 > x2)
		SwapInts(x1,x2);
	if (y1 > y2)
		SwapInts(y1,y2);

	if (Phase == 1)
	/* Find the range of the data, count rects */
	{
		count++;
		if (!flag)
		{
			flag = 1;
			CoverAll.boundary[0] = x1;
			CoverAll.boundary[1] = y1;
			CoverAll.boundary[NUMDIMS] = x2;
			CoverAll.boundary[NUMDIMS+1] = y2;
		}
		else
		{
			CoverAll.boundary[0] = min(CoverAll.boundary[0], x1);
			CoverAll.boundary[NUMDIMS] = max(CoverAll.boundary[NUMDIMS], x2);
			CoverAll.boundary[1] = min(CoverAll.boundary[1], y1);
			CoverAll.boundary[NUMDIMS+1] = max(CoverAll.boundary[NUMDIMS+1], y2);
		}
	}
	else if (Phase == 2)
	/* Insert rects into index. Do measurements on last 10% of inserts. */
	{
		r.boundary[0]         = x1;
		r.boundary[1]         = y1;
		r.boundary[NUMDIMS]   = x2;
		r.boundary[NUMDIMS+1] = y2;
		tid = NewTid();
		if (tid > 0.9 * count)
		{
			StatFlag = TRUE;
			StartClock();
			InsertRect(&r, tid, &Root, 0);
			StopClock();
			StatFlag = FALSE;
		}
		else
		{
			InsertRect(&r, tid, &Root, 0);
		}
	}
	else if (Phase == 3)
	/* Delete 10% of rects in index. Use every 10th one. */
	{
		r.boundary[0]         = x1;
		r.boundary[1]         = y1;
		r.boundary[NUMDIMS]   = x2;
		r.boundary[NUMDIMS+1] = y2;
		tid = NewTid();
		if (tid%10 == 0)
		{
			StatFlag = TRUE;
			StartClock();
			result = DeleteRect(&r, tid, &Root);
			assert(!result);
			StopClock();
			StatFlag = FALSE;
		}
	}
	/* if Phase not 1, 2 or 3, do nothing - for test parsing. */
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 51
# define YYLAST 100
short yyact[]={

  23,  41,   6,  18,   8,  20,  11,   5,   8,   7,
  18,  13,  17,   7,   6,  42,   8,  92,  39,  17,
  90,   7,  88,  86,  83,  82,  80,  78,  76,  74,
  72,  70,  69,  67,  64,  62,  61,  59,  56,  54,
  53,  51,  48,  46,  44,  43,  36,  28,  22,  33,
  30,  29,  26,  85,  35,  38,  32,   4,  10,   2,
   9,  91,  89,  12,  87,  84,  81,  75,  68,  60,
   9,  24,  52,  27,  77,  71,  63,  55,  47,  31,
  16,  66,  58,  50,  37,  25,  15,   3,  40,  21,
  19,  14,  79,  45,  73,  65,  57,  49,  34,   1 };
short yypact[]={

-261,-1000,-257,-249,-1000,-260,-252,-266,-216,-1000,
-1000,-259,-257,-1000,-1000,-1000,-1000,-1000,-208,-1000,
-1000,-1000,-217,-209,-1000,-210,-212,-203,-218,-1000,
-248,-212,-1000,-270,-254,-219,-220,-248,-1000,-221,
-1000,-1000,-222,-1000,-1000,-1000,-1000,-223,-1000,-224,
-225,-1000,-226,-1000,-1000,-227,-1000,-228,-229,-1000,
-230,-1000,-1000,-231,-1000,-232,-233,-1000,-234,-1000,
-1000,-235,-1000,-236,-1000,-237,-1000,-238,-1000,-239,
-1000,-240,-1000,-1000,-205,-241,-1000,-242,-1000,-244,
-1000,-247,-1000 };
short yypgo[]={

   0,  99,  98,  97,  96,  95,  94,  92,  57,  91,
  90,  89,  59,  58,  87,  86,  85,  84,  55,  83,
  82,  81,  80,  79,  56,  78,  77,  76,  75,  74,
  73,  72,  69,  68,  67,  66,  65,  64,  62,  61 };
short yyr1[]={

   0,   2,   3,   4,   5,   6,   7,   2,   8,   8,
   8,  12,  12,   1,   1,   1,  13,  16,  15,  17,
  17,  17,  19,  20,  21,  18,  22,  25,  26,  27,
  28,  29,  24,  23,  23,  23,   9,   9,  11,  14,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
  10 };
short yyr2[]={

   0,   0,   0,   0,   0,   0,   0,  12,   2,   2,
   2,   1,   2,   0,   2,   3,   3,   0,   4,   0,
   1,   2,   0,   0,   0,   8,   3,   0,   0,   0,
   0,   0,  12,   0,   1,   2,   1,   1,   4,   2,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  24 };
short yychk[]={

-1000,  -1, -12, -14,  -8, 268, 263, 270, 265,  -8,
 -13, 263, -12, 271,  -9, -15, -22, 271, 262, -10,
 271, -11, 264, 259, -13, -16, 260, -30, 264, 260,
 260, -23, -24, 261,  -2, 257, 264, -17, -18, 266,
 -24, 271, 269, 264, 264, -18, 264, -25, 264,  -3,
 -19, 264, -31, 264, 264, -26, 264,  -4, -20, 264,
 -32, 264, 264, -27, 264,  -5, -21, 264, -33, 264,
 264, -28, 264,  -6, 264, -34, 264, -29, 264,  -7,
 264, -35, 264, 264, -36, 258, 264, -37, 264, -38,
 264, -39, 264 };
short yydef[]={

  13,  -2,   0,   0,  11,   0,   0,   0,   0,  12,
  14,   0,   0,  39,   8,  36,  37,  17,   0,   9,
  40,  10,   0,   0,  15,   0,  33,   1,   0,  16,
  19,  26,  34,   0,   0,   0,   0,  18,  20,   0,
  35,  27,   0,   2,  38,  21,  22,   0,  41,   0,
   0,  28,   0,   3,  23,   0,  42,   0,   0,  29,
   0,   4,  24,   0,  43,   0,   0,  30,   0,   5,
  25,   0,  44,   0,  31,   0,   6,   0,  45,   0,
  32,   0,   7,  46,   0,   0,  47,   0,  48,   0,
  49,   0,  50 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 2:
# line 96 "y.spec"
{ axlo = tokenval; } break;
case 3:
# line 97 "y.spec"
{ axhi = tokenval; } break;
case 4:
# line 98 "y.spec"
{ axsep = tokenval; } break;
case 5:
# line 99 "y.spec"
{ aylo = tokenval; } break;
case 6:
# line 100 "y.spec"
{ ayhi = tokenval; } break;
case 7:
# line 101 "y.spec"
{ aysep = tokenval; } break;
case 17:
# line 116 "y.spec"
{ getlayer(Tokenstring); } break;
case 22:
# line 123 "y.spec"
{x1 = tokenval;} break;
case 23:
# line 124 "y.spec"
{y1 = tokenval;} break;
case 24:
# line 125 "y.spec"
{x2 = tokenval;} break;
case 25:
# line 127 "y.spec"
{
			y2 = tokenval;
			ProcessBox(x1, y1, x2, y2);
		  } break;
case 27:
# line 134 "y.spec"
{strcpy(label, Tokenstring);} break;
case 28:
# line 135 "y.spec"
{x1 = tokenval;} break;
case 29:
# line 136 "y.spec"
{y1 = tokenval;} break;
case 30:
# line 137 "y.spec"
{x2 = tokenval;} break;
case 31:
# line 138 "y.spec"
{y2 = tokenval;} break;
case 32:
# line 140 "y.spec"
{
			side = tokenval;
		  } break;
case 39:
# line 156 "y.spec"
{ strcpy(Technology, Tokenstring); } break;
case 40:
# line 159 "y.spec"
{
			strcpy(subname, Tokenstring);
			axlo = axhi = axsep = aylo = ayhi = aysep = 0;
		  } break;
case 41:
# line 165 "y.spec"
{t[0][0] = tokenval;} break;
case 42:
# line 166 "y.spec"
{t[1][0] = tokenval;} break;
case 43:
# line 167 "y.spec"
{t[2][0] = tokenval;} break;
case 44:
# line 168 "y.spec"
{t[0][1] = tokenval;} break;
case 45:
# line 169 "y.spec"
{t[1][1] = tokenval;} break;
case 46:
# line 170 "y.spec"
{t[2][1] = tokenval;} break;
case 47:
# line 172 "y.spec"
{x1 = tokenval;} break;
case 48:
# line 173 "y.spec"
{y1 = tokenval;} break;
case 49:
# line 174 "y.spec"
{x2 = tokenval;} break;
case 50:
# line 176 "y.spec"
{
			int xx1, xx2, yy1, yy2;
			y2 = tokenval;
			xx1 = x1*t[0][0]+y1*t[1][0]+t[2][0];
			yy1 = x1*t[0][1]+y1*t[1][1]+t[2][1];
			xx2 = x2*t[0][0]+y2*t[1][0]+t[2][0];
			yy2 = x2*t[0][1]+y2*t[1][1]+t[2][1];
			ProcessBox(xx1, yy1, xx2, yy2);
		  } break; 
		}
		goto yystack;  /* stack new state and value */

	}
