
#include "options.h"
#include <stdio.h>
#include "assert.h"
#include "macros.h"
#include "index.h"
#include "split.e.h"

# ifndef	lint
	static	char	splitlSccsid[] = "%W% %G%";
# endif	lint

#ifdef GRAPHICS
#	define UNIX
#	include "/jb/ingres/toni/cad/lib/mfb.h"
#endif


/*-----------------------------------------------------------------------------
| Split a node.
| Divides the nodes branches and the extra one between two nodes.
| Old node is one of the new ones, and one really new one is created.
| Tries more than one method for choosing a partition, uses best result.
-----------------------------------------------------------------------------*/
SplitNode(n, b, nn)
register struct Node *n;
register struct Branch *b;
register struct Node **nn;
{
	struct Node *NewNode();
	int level, i;
	struct Rect NullRect();
	register struct Rect *cov0, *cov1;
	register int size0, size1, area0, area1;

	assert(n);
	assert(b);
	assert(nn);
	assert(NUMDIMS == 2);

#	ifdef PRINT
		printf("Splitting:\n");
		PrintNode(n);
		PrintBranch(b);
#	endif

	if (StatFlag)
	{
		if (Deleting)
			DeSplitCount++;
		else
			InSplitCount++;
	}

	/* load all the branches into a buffer, initialize old node */
	level = n->level;
	GetBranches(n, b);

#	ifdef SHOWSPLIT
		/* Indicate that a split is about to take place */
		MFBSetColor(RED);
		for (i=0; i<NODECARD+1; i++)
		{
			PrintRect(&BranchBuf[i].rect);
		}
		MFBSetColor(YELLOW);
		PrintRect(&CoverSplit);
		GraphChar();
#	endif

	/* find partitions */
	/* assume wolog the first branch is in group 0 */
	/* others placed in groups by recursive routine */
	BestArea = 2 * CoverSplitArea + 1;
	Partition[0] = 0;
	size0 = 1;
	size1 = 0;
	area0 = RectArea(&BranchBuf[0].rect);
	area1 = 0;
	cov0 = &BranchBuf[0].rect;
	cov1 = &NullRect();
	Recur(size0, size1, area0, area1, cov0, cov1);
	assert(BestArea <= 2 * CoverSplitArea);

	/* record how good the split was for statistics */
	if (StatFlag && !Deleting)
		SplitMeritSum += (float)CoverSplitArea / BestArea;

	/* put branches from buffer into 2 nodes according to chosen partition */
	*nn = NewNode();
	(*nn)->level = n->level = level;
	LoadNodes(n, *nn);
	assert(n->count+(*nn)->count == NODECARD+1);

#	ifdef PRINT
		printf("group 0:\n");
		PrintNode(n);
		printf("group 1:\n");
		PrintNode(*nn);
		printf("\n");
#	endif

#	ifdef SHOWSPLIT
		MFBSetColor(YELLOW);
		PrintRect(&CoverSplit);
		MFBSetColor(WHITE);
		PrintRect(&BestCover[0]);
		PrintRect(&BestCover[1]);
		MFBSetColor(CYAN);
		for (i=0; i<NODECARD+1; i++)
		{
			if (BestPartition[i] == 0)
				PrintRect(&BranchBuf[i].rect);
		}
		MFBSetColor(MAGENTA);
		for (i=0; i<NODECARD+1; i++)
		{
			if (BestPartition[i] == 1)
				PrintRect(&BranchBuf[i].rect);
		}

		GraphChar();

		EraseRect(&CoverSplit);
		EraseRect(&BestCover[0]);
		EraseRect(&BestCover[1]);
		for (i=0; i<NODECARD+1; i++)
		{
			EraseRect(&BranchBuf[i].rect);
		}
#	endif
}

/*-----------------------------------------------------------------------------
| Recursive routine to try all possible combinations of rects for a split.
-----------------------------------------------------------------------------*/
Recur(size0, size1, area0, area1, cov0, cov1)
register int size0, size1;
int area0, area1;
register struct Rect *cov0, *cov1;
{
	struct Rect newCover, CombineRect();
	register int taken, newArea;

#	ifdef PRINT
		printf("recur  sizes = %d %d  areas = %d %d  covers =\n",
			size0, size1, area0, area1);
		PrintRect(cov0);
		PrintRect(cov1);
#	endif

	if (StatFlag && !Deleting)
		CallCount++;

	taken = size0 + size1;
	if (taken > NODECARD)
	{
		if ((newArea = area0 + area1) < BestArea)
		{
			/* bottom of recursion, evaluate a split */
			assert(size0 >= MinFill);
			assert(size1 >= MinFill);
			assert(taken == NODECARD + 1);
			if (StatFlag && !Deleting)
				EvalCount++;

			BestArea = newArea;
			for (taken=0; taken<NODECARD+1; taken++)
			{
				assert(Partition[taken]==0 || Partition[taken]==1);
				BestPartition[taken] = Partition[taken];
#				ifdef SHOWSPLIT
					BestCover[0] = *cov0;
					BestCover[1] = *cov1;
#				endif
			}

#			ifdef PRINT
				printf("Evaluating: BestArea = %d  newArea = %d\n",
					BestArea, newArea);
				PrintRect(cov0);
				PrintRect(cov1);
				for (taken=0; taken<NODECARD+1; taken++)
				{
					printf("%d ", Partition[taken]);
				}
				printf("\n");
#			endif PRINT
		}
	}
	else
	{
		if (size1 <= NODECARD - MinFill)
		{
			newCover = CombineRect(cov1, &BranchBuf[taken].rect);
			newArea = RectArea(&newCover);
			if (newArea < BestArea)
			{
				Partition[taken] = 1;
				Recur(size0, size1+1, area0, newArea, cov0, &newCover);
			}
		}
		if (size0 <= NODECARD - MinFill)
		{
			newCover = CombineRect(cov0, &BranchBuf[taken].rect);
			newArea = RectArea(&newCover);
			if (newArea < BestArea)
			{
				Partition[taken] = 0;
				Recur(size0+1, size1, newArea, area1, &newCover, cov1);
			}
		}
	}
}

/*-----------------------------------------------------------------------------
| Load branch buffer with branches from full node plus the extra branch.
-----------------------------------------------------------------------------*/
GetBranches(n, b)
register struct Node *n;
register struct Branch *b;
{
	register int i;
	struct Rect CombineRect();

	assert(n);
	assert(b);

	/* load the branch buffer */
	for (i=0; i<NODECARD; i++)
	{
		assert(n->branch[i].child);  /* node should have every entry full */
		BranchBuf[i] = n->branch[i];
	}
	BranchBuf[NODECARD] = *b;

	/* calculate rect containing all in the set */
	CoverSplit = BranchBuf[0].rect;
	for (i=1; i<NODECARD+1; i++)
	{
		CoverSplit = CombineRect(&CoverSplit, &BranchBuf[i].rect);
	}
	CoverSplitArea = RectArea(&CoverSplit);

	InitNode(n);
}

/*-----------------------------------------------------------------------------
| Copy branches from the buffer into two nodes according to the partition.
-----------------------------------------------------------------------------*/
LoadNodes(n, q)
register struct Node *n, *q;
{
	register int i, count0 = 0, count1 = 0;
	assert(n);
	assert(q);

	for (i=0; i<NODECARD+1; i++)
	{
		if (BestPartition[i] == 0)
		{
			assert(++count0 <= NODECARD);
			AddBranch(&BranchBuf[i], n, NULL);
		}
		else if (BestPartition[i] == 1)
		{
			assert(++count1 <= NODECARD);
			AddBranch(&BranchBuf[i], q, NULL);
		}
		else
			assert(FALSE);
	}
}

/*-----------------------------------------------------------------------------
| Erase all rects in the set to be split by drawing them black.  Graphics only.
-----------------------------------------------------------------------------*/
EraseData()
{
	int i;

	for (i=0; i<NODECARD+1; i++)
		EraseRect(&BranchBuf[i].rect);
}
