
#include "options.h"
#include <stdio.h>
#include "assert.h"
#include <ctype.h>
#include "sccs.h"
#include "macros.h"
#include "index.h"

# ifndef	lint
	static	char	mainSccsid[] = "%W% %G%";
# endif	lint

#ifdef GRAPHICS
#	define UNIX
#	include "/jb/ingres/toni/cad/lib/mfb.h"
#endif

/* the current caesar file to read */
FILE *Infile;

main(argc, argv)
int argc;
char *argv[];
{
	int i, nextArg = 1, firstFile;
	FILE *fopen();
	struct Node *NewIndex();
	int NewTid(), InsertRect();
	struct Rect r;
	extern char TermType[];
#	ifdef GRAPHICS
		extern struct MFB *Mfb;
		struct MFB *StartGraphics();
#	endif GRAPHICS

	Initialize(argc, argv, &nextArg);

	/* make one pass through files to find min and max x and y, # of rects */
	Phase = 1;
	firstFile = nextArg;
	for (; nextArg<argc; nextArg++)
	{
		printf("%s\n", argv[nextArg]);
		fflush(stdout);
		if ((Infile = fopen(argv[nextArg], "r")) == NULL)
		{
			error("main: can't open file");
		}
		else
		{
			yyparse();
			fclose(Infile);
		}
	}
	printf("CoverAll:\n");
	PrintRect2(&CoverAll);

#	ifdef GRAPHICS
		Mfb = StartGraphics();
#	endif GRAPHICS

	Root = NewIndex();

	/* Insert rectangles into index structure */
	Phase = 2;
	ResetTid();
	ResetClock();
	for (nextArg=firstFile; nextArg<argc; nextArg++)
	{
#		ifdef PRINT
			printf ("Inserting from file %s\n", argv[nextArg]);
			fflush(stdout);
#		endif
		if ((Infile = fopen(argv[nextArg], "r")) == NULL)
		{
#			ifdef GRAPHICS
				EndGraphics();
#			endif
			error("main: can't open file");
		}
		else
		{
			yyparse();
			fclose(Infile);
		}
	}
#	ifdef GRAPHICS
		ClearScreen();
#	endif

	PrintIndex(Root);

#	ifdef GRAPHICS
		GraphChar();
		EndGraphics();
#	endif

	InsertStats();

#	ifdef GRAPHICS
		getchar();
		Mfb = StartGraphics();
#	endif

	/* Do some random searches using the index */
	PrintRect(&CoverAll);
#	ifdef GRAPHICS
		MFBSetColor(RED);
		PrintData(Root);
#	endif
	ResetClock();
	StartClock();
	for (i=0; i<100; i++)
	{
		SearchRect(&r, &CoverAll);
#		ifdef GRAPHICS
			MFBSetColor(WHITE);
			PrintRect(&r);
#		endif
#		ifdef PRINT
			printf("Search rect:\n");
			PrintRect(&r);
#		endif
		HitCount += Search(Root, &r);
		SearchCount++;
	}
	StopClock();

#	ifdef GRAPHICS
		GraphChar();
		EndGraphics();
#	endif

	SearchStats();

#	ifdef GRAPHICS
		getchar();
		Mfb = StartGraphics();
#	endif

	/* Delete some rectangles.  Which ones decided in yyparse. */
	Phase = 3;
	ResetTid();
	ResetClock();
	for (nextArg=firstFile; nextArg<argc; nextArg++)
	{
#		ifdef PRINT
			printf ("Deleting from file %s\n", argv[nextArg]);
			fflush(stdout);
#		endif
		if ((Infile = fopen(argv[nextArg], "r")) == NULL)
		{
			error("main: can't open file");
		}
		else
		{
			yyparse();
			fclose(Infile);
		}
	}

#	ifdef GRAPHICS
		GraphChar();
		EndGraphics();
#	endif

	DeleteStats();
}

Initialize(argc, argv, next)
int argc;
char *argv[];
int *next;
{
	int i;

	/* First argument is terminal type, e.g. "AE", if GRAPHICS defined */
#	ifdef GRAPHICS
		assert(argc >= 3);
		strcpy(TermType, argv[(*next)++]);
#	endif

	/* Set up balance criterion for node splitting */
	assert(argc >= 2);
	if (!strcmp(argv[*next], "half"))
		MinFill = NODECARD / 2;
	else if (!strcmp(argv[*next], "third"))
		MinFill = NODECARD / 3;
	else
	{
		i = sscanf(argv[*next], "%d", &MinFill);
		assert(i==1);
	}
	(*next)++;
	GeneralStats();

	/* Initialize all-covering rectangle to be whole space */
	for (i=0; i<NUMDIMS; i++)
	{
		CoverAll.boundary[i] = MININT;
		CoverAll.boundary[NUMDIMS+i] = MAXINT;
	}
}
