##############################################################################
#
# Common Tcl/Tk procedures for the Assembly ToolKit
#
# Copyright by Chris Paredis and Sripal Mehta (c) 1997
#
# History:
#     Started   1-3-1997
#     Appended  6-18-1997
##############################################################################

global Global
set Global(geometrySimulationWindow) +100+100
set Global(geometryFileNameWindow)  +400+350
set Global(geometryConfirmationWindow) +500+500
set Global(geometryPartsWindow) +400+350
set Global(BackGround) #ccc
set Global(OpFile) ""
set Global(AsmFile) ""
set Global(ToolFile) ""


##############################################################################
# this procedure interacts with the user to retrieve a file name
##############################################################################
proc GetFileName { directory filter } {

    #-----------------------------------------------------------------------
    # Set up the global variables and the internal state of the routine
    #-----------------------------------------------------------------------
    # global variables for communication with sub procedures
    global Global

    # check the input variables
    if { $filter == "" } {
	set Global(FNFilter) "*"
    } else {
	set Global(FNFilter) $filter
    }
    if { $directory == "" } {
	set directory [pwd]
    }
    set Global(FNFileName) ""
    cd $directory
    set Global(FNPath) [pwd]

    #-----------------------------------------------------------------------
    # Create the geometry (from top to bottom)
    #-----------------------------------------------------------------------
    # create the toplevel window
    toplevel .fn  -bg $Global(BackGround)
    wm title .fn "File Name"
    wm geometry .fn $Global(geometryFileNameWindow)

    # create the path entry
    frame .fn.path -bg $Global(BackGround)
    pack  .fn.path
    label .fn.path.label -text "Path:"  -bg $Global(BackGround)
    entry .fn.path.name  -width 33 -relief sunken \
	-textvariable Global(FNPath) \
	-bg $Global(BackGround)
    pack  .fn.path.label .fn.path.name -padx 2m -anchor w

    # create the file entry
    frame .fn.file -bg $Global(BackGround)
    pack  .fn.file
    label .fn.file.label -text "File Name:"  -bg $Global(BackGround)
    entry .fn.file.name  -width 33 -relief sunken \
	-textvariable Global(FNFileName) \
	-bg $Global(BackGround)
    pack  .fn.file.label .fn.file.name -padx 2m -anchor w

    # create the listbox with the contents of the current directory
    frame  .fn.list  -bg $Global(BackGround)
    pack   .fn.list -padx 6
    scrollbar .fn.scroll -command ".fn.box yview" -bg $Global(BackGround)
    pack   .fn.scroll -in .fn.list -side right -fill y
    listbox .fn.box -relief sunken -yscrollcommand ".fn.scroll set" \
	-width 30 -bg $Global(BackGround)
    pack   .fn.box -in .fn.list -side left -expand 1
    SetFileList .fn.box $Global(FNFilter)
  
    # create the filter entry
    frame .fn.filter -bg $Global(BackGround)
    pack  .fn.filter
    label .fn.filter.label -text "Filter:"  -bg $Global(BackGround)
    entry .fn.filter.name  -width 33 -relief sunken \
	-textvariable Global(FNFilter) \
	-bg $Global(BackGround)
    pack  .fn.filter.label .fn.filter.name -padx 2m -anchor w

    # create the action buttons
    frame  .fn.action -bg $Global(BackGround)
    pack   .fn.action
    button .fn.ok -text "OK" -bg $Global(BackGround)
    button .fn.filter_button -text "Filter" -bg $Global(BackGround)
    button .fn.cancel -text "Cancel" -bg $Global(BackGround)
    pack   .fn.ok .fn.filter_button .fn.cancel -side left -in .fn.action \
	-padx 6 -pady 6

    #-----------------------------------------------------------------------
    # Set the bindings and button commands
    #-----------------------------------------------------------------------
    bind  .fn.path.name <Return> {
	set Global(FNFileName) ""
	.fn.ok invoke
    }
    bind  .fn.file.name <Return> {.fn.ok invoke} 
    bind  .fn.filter.name <Return> {.fn.filter_button invoke}
    bind .fn.box <ButtonRelease-1> {
	set index [.fn.box curselection]
	if { $index != "" } {
	    set Global(FNFileName) [.fn.box get $index]
	}
    }
    bind .fn.box <Double-Button-1> {
	set Global(FNFileName) [.fn.box get [.fn.box curselection]]
	.fn.ok invoke
    }
    .fn.ok config -command {
	if { [file isdirectory $Global(FNPath)] } {
	    cd $Global(FNPath)
	    set Global(FNPath) [pwd]
	    if { [file isdirectory $Global(FNPath)/$Global(FNFileName)] } {
		set Global(FNFileName) [string trimright $Global(FNFileName) /]
		cd $Global(FNPath)/$Global(FNFileName)
		set Global(FNPath) [pwd]
		set Global(FNFileName) ""
		SetFileList .fn.box $Global(FNFilter)
		update
	    } else {
		set Global(geometryFileNameWindow) [wm geometry .fn]
		update
		destroy .fn
	    }
	} else {
	    set Global(FNPath) [pwd]
	}
    }
    .fn.filter_button config -command {
	SetFileList .fn.box $Global(FNFilter)
	update
    }
    .fn.cancel config -command {
	set Global(geometryFileNameWindow) [wm geometry .fn]
	destroy .fn;
	set Global(FNFileName) ""
    }
  
    #-----------------------------------------------------------------------
    # Clean up when done
    #-----------------------------------------------------------------------
    # wait until the window is destroyed; then, return the filename
    tkwait window .fn
    update
    if { $Global(FNFileName) == "" } {
	return ""
    } else {
	return $Global(FNPath)/$Global(FNFileName)
    }
}

##############################################################################
# this procedure reads the current directory and stores the filtered
# contents in a listbox
##############################################################################
proc SetFileList { listbox filter } {
    # clear the current entries in the listbox
    eval $listbox delete 0 end

    # insert the parent directory
    # (this is a roundabout way of checking whether we are at the root
    # of the directory structure; However it works for both unix as windows)
    set current_dir [pwd]
    cd ..
    if { [pwd] != $current_dir } {
	eval $listbox insert end "../"
    }
    cd $current_dir

    # first get all the directories
    if { [catch { set FileList [lsort [glob */]] }] } {
	set FileList ""
    }
    foreach i $FileList {
	eval $listbox insert end $i
    }

    # then get all the files that match the filter
    if { [catch { set FileList [lsort [glob $filter]] }] } {
	set FileList ""
    }
    foreach i $FileList {
	if { [file isdirectory $i] } {
	    # do nothing: directories are already included
	} else {
	    eval $listbox insert end $i
	}
    }
}
