sqrt_2 = sqrt(1000);
max_cor = 12;

% load .mat file
[filename pathname] = uigetfile('*.mat');   
load([pathname filename]);

len_y = size(cor_mat, 1);
len_x = size(cor_mat, 2);

dp_mat = zeros(len_y, len_x);
path_mat = dp_mat;
dp_mat(1, 1) = min(cor_mat(1, 1), max_cor);
path_mat(1, 1) = 0;

for i = 2 : len_y
    dp_mat(i, 1) = min(cor_mat(i, 1), max_cor) + dp_mat(i - 1, 1);
    path_mat(i, 1) = 2;
end

for j = 2 : len_x
    dp_mat(1, j) = min(cor_mat(1, j), max_cor) + dp_mat(1, j - 1);
    path_mat(1, j) = 3;
end

% dp_mat(2, 2) = cor_mat(2, 2) + dp_mat(1, 1);
% path_mat(2, 2) = 1;
% 
% for i = 3 : len_y
%     [min_value, min_pos] = min([dp_mat(i - 1, 1), dp_mat(i - 2, 1) + cor_mat(i - 1, 2)]);
%     dp_mat(i, 2) = cor_mat(i, 2) + min_value;
%     path_mat(i, 2) = min_pos;
% end
% 
% for j = 3 : len_x
%     [min_value, min_pos] = min([dp_mat(1, j - 1), dp_mat(1, j - 1) + dp_mat(1, j - 2) + cor_mat(2, j - 1), dp_mat(1, j - 2) + cor_mat(2, j - 1)]);    
%     dp_mat(2, j) = cor_mat(2, j) + min_value;
%     path_mat(2, j) = min_pos;
% end

for i = 2 : len_y
    for j = 2 : len_x
%         [min_value, min_pos] = min([dp_mat(i - 1, j - 1), dp_mat(i - 2, j - 1) + cor_mat(i - 1, j), dp_mat(i - 1, j - 2) + cor_mat(i, j - 1)]);
        %simple DTW
        [min_value, min_pos] = min([dp_mat(i - 1, j - 1), dp_mat(i - 1, j), dp_mat(i, j - 1)]);        
        dp_mat(i, j) = min(cor_mat(i, j), max_cor) + min_value;
%         temp = min(cor_mat(i, j), max_cor);
%         [min_value, min_pos] = min([dp_mat(i - 1, j - 1) + temp * sqrt_2, dp_mat(i - 1, j) + temp, dp_mat(i, j - 1) + temp]);        
%         dp_mat(i, j) = min_value;
        path_mat(i, j) = min_pos;            
    end    
end

i = len_y;
j = len_x;
path_x = zeros(1, len_x + len_y - 1);
path_y = path_x;
count = 0;
while ((i > 1) | (j > 1))
    count = count + 1;
    path_x(count) = j;
    path_y(count) = i;
    switch path_mat(i, j)
    case 1
        i = i - 1;
        j = j - 1;
%     case 2
%         count = count + 1;
%         path_x(count) = j;
%         path_y(count) = i - 1;    
%         i = i - 2;        
%         j = j - 1;
%     case 3
%         count = count + 1;
%         path_x(count) = j - 1;
%         path_y(count) = i;    
%         i = i - 1;        
%         j = j - 2;
    case 2
        i = i - 1;
    case 3
        j = j - 1;
    end
end 

figure('color', 'w', 'Units', 'inches', 'Position', [1, 1, 5, 4.5]);
imagesc(beats2(1 : len_x) / fs2, beats1(1 : len_y) / fs1, cor_mat);   
%title(['Optimal Path in Chroma Similarity Matrix : MIDI Rendered Audio vs. Audio Recording']); xlabel(['<',f2,'> Time(s)']); ylabel(['<',f1,'> Time(s)']); axis xy; colorbar
%title('{\fontname{Arial} \fontsize{12} \bf Optimal Path in Similarity Matrix}'); xlabel('{\fontname{Arial} \fontsize{10} \bf Audio from MIDI (s)}'); ylabel('{\fontname{Arial} \fontsize{10} \bf Acoustic Recording (s)}'); axis xy;
%title('{\fontname{Times New Roman} \fontsize{12} \bf Optimal Path in Similarity Matrix}'); 
xlabel('{\fontname{Times New Roman} \fontsize{10} MIDI (s)}'); ylabel('{\fontname{Times New Roman} \fontsize{10} Acoustic Recording (s)}'); axis xy;
colormap gray;
hold on
plot(path_x(count : -1 : 1) * window_size, path_y(count : -1 : 1) * window_size, 'w', 'LineWidth', 2);
hold off
%set(gca, 'FontName', 'Arial', 'FontWeight', 'bold');
%set(gca, 'FontName', 'Times New Roman', 'FontWeight', 'bold');
count
average = dp_mat(len_y, len_x) / count
ratio = average / mean(min(mean(cor_mat), max_cor))

