/*
 * Decompiled with CFR 0.152.
 */
package com.ow.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Stopwatch {
    public static final int WRITE_ON_LAP = 0;
    public static final int WRITE_ON_CLOSE = 1;
    static final int timeField = 13;
    static final long maxTime;
    public static final Stopwatch SYSOUT;
    int writeMode;
    long lastTime;
    Writer outw;
    String filename;
    StringBuffer messages;
    boolean writerIsMine;

    public Stopwatch(String string, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("illegal writeMode value: " + n);
        }
        this.filename = string;
        this.writeMode = n;
        this.lastTime = 0L;
        this.writerIsMine = true;
        if (n == 0) {
            try {
                this.outw = new FileWriter(string);
            }
            catch (IOException iOException) {}
        } else {
            this.messages = new StringBuffer();
        }
        this.lap("stopwatch started");
    }

    public Stopwatch(Writer writer, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("illegal writeMode value: " + n);
        }
        this.outw = writer;
        this.writeMode = n;
        this.lastTime = 0L;
        this.writerIsMine = false;
        if (n == 1) {
            this.messages = new StringBuffer();
        }
        this.lap("stopwatch started");
    }

    public Stopwatch(OutputStream outputStream, int n) {
        this(new PrintWriter(outputStream), n);
    }

    private Stopwatch(int n) {
        this(System.out, n);
    }

    public void lap(String string) {
        String string2 = this.record(string);
        if (this.writeMode == 0) {
            try {
                this.outw.write(string2);
                this.outw.flush();
            }
            catch (IOException iOException) {}
        } else {
            this.messages.append(string2);
        }
    }

    public void close() {
        try {
            if (this.writeMode == 1) {
                if (this.writerIsMine) {
                    this.outw = new FileWriter(this.filename);
                }
                this.outw.write(this.messages.toString());
                this.outw.flush();
            }
            if (this.writerIsMine) {
                this.outw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String record(String string) {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastTime;
        this.lastTime = l;
        StringBuffer stringBuffer = new StringBuffer(13 + string.length() + 2);
        long l3 = l2 == 0L ? 1L : l2;
        while (l3 < maxTime) {
            stringBuffer.append(' ');
            l3 *= 10L;
        }
        stringBuffer.append(l2);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    static {
        SYSOUT = new Stopwatch(0);
        long l = 1L;
        int n = 0;
        while (n < 13) {
            l *= 10L;
            ++n;
        }
        maxTime = l;
    }
}

