/*
 * Decompiled with CFR 0.152.
 */
package com.ow.util;

import com.kb.client.KBException;
import com.kb.kbddutil.KBProperties;
import com.kb.oms.OMSAPI;
import com.kb.oms.OMSAnswers;
import com.kb.oms.OMSException;
import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryCache {
    public static final String iodePropPfx = "com.ow.iode.";
    public static final String reportHitsProp = "com.ow.iode.reportCacheHits";
    public static final boolean reportHitsDefault = false;
    public static boolean reportHitsFlag;
    static final Symbol topSym;
    OMSAPI omsapi;
    Map askCache;
    Map disambCache;
    Map usesCache;
    Map sentsCache;
    Set recogYes;
    Set recogNo;

    public QueryCache(OMSAPI oMSAPI) {
        this.omsapi = oMSAPI;
        this.init();
    }

    public void clear() {
        this.init();
    }

    private void init() {
        this.askCache = new HashMap();
        this.disambCache = new HashMap();
        this.usesCache = new HashMap();
        this.sentsCache = new HashMap();
        this.recogYes = new HashSet();
        this.recogNo = new HashSet();
    }

    public boolean mightHit(OWL oWL) {
        return this.askCache.get(oWL) != null;
    }

    public boolean mightHit(String string) {
        return this.disambCache.get(string) != null;
    }

    public OMSAnswers ask(OWL oWL) throws OMSException, KBException {
        OMSAnswers oMSAnswers = (OMSAnswers)this.askCache.get(oWL);
        if (reportHitsFlag) {
            System.out.println((oMSAnswers != null ? "hit: " : "no hit: ") + oWL);
        }
        if (oMSAnswers == null) {
            oMSAnswers = this.omsapi.ask(oWL);
            this.askCache.put(oWL, oMSAnswers);
        }
        return oMSAnswers;
    }

    public Symbol disambiguateSymbol(String string) throws KBException {
        Symbol symbol = (Symbol)this.disambCache.get(string);
        if (symbol == null) {
            symbol = this.omsapi.disambiguateSymbol(string);
            this.disambCache.put(string, symbol);
        }
        return symbol;
    }

    public boolean isInOntology(Symbol symbol) throws KBException, OMSException {
        if (this.recogYes.contains(symbol)) {
            return true;
        }
        if (this.recogNo.contains(symbol)) {
            return false;
        }
        Form form = new Form((OWL)topSym, (OWL)symbol);
        boolean bl = false;
        try {
            this.omsapi.ask((OWL)form);
            this.recogYes.add(symbol);
            bl = true;
        }
        catch (OMSException oMSException) {
            this.recogNo.add(symbol);
            bl = false;
        }
        return bl;
    }

    public Form[] getUses(Symbol symbol) throws KBException {
        Form[] formArray = (Form[])this.usesCache.get(symbol);
        if (formArray == null) {
            formArray = this.omsapi.getUses(symbol);
            this.usesCache.put(symbol, formArray);
        }
        return formArray;
    }

    public OWL getSentence(Form form) throws KBException {
        OWL oWL = (OWL)this.sentsCache.get(form);
        if (oWL == null) {
            oWL = this.omsapi.getSentence(form);
            this.sentsCache.put(form, oWL);
        }
        return oWL;
    }

    static {
        topSym = new Symbol("RootCtx.Top");
        reportHitsFlag = KBProperties.getBoolean(reportHitsProp);
    }
}

