/*
 * Decompiled with CFR 0.152.
 */
package com.ow.util;

import com.kb.logic.ConstSymbol;
import com.kb.logic.Formula;
import com.kb.logic.Num;
import com.kb.logic.QString;
import com.kb.logic.Rule;
import com.kb.logic.Struct;
import com.kb.logic.Term;
import com.kb.logic.Variable;
import com.kb.oms.OMSAnswers;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.util.StringUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class OWUtil {
    public static final int maxDispLen = 20;
    public static final String newLineStr = "\\n";

    private OWUtil() {
    }

    public static boolean hasContext(String string) {
        return string.indexOf(46) != -1;
    }

    public static String contextRelativeName(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        String string = object2.toString();
        return string.equals(OWUtil.getContextName(object)) ? OWUtil.trimContext(object) : object.toString();
    }

    public static String getContextName(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        int n = string.lastIndexOf(46);
        return n == -1 ? null : string.substring(0, n);
    }

    public static String trimContext(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Symbol) {
            return OWUtil.trimContext((Symbol)object);
        }
        if (object instanceof Form) {
            return OWUtil.trimContext((Form)object);
        }
        if (object instanceof Formula) {
            return OWUtil.trimContext((Formula)object);
        }
        return OWUtil.trimContext(object.toString());
    }

    public static String trimContext(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String trimContext(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        String string = symbol.toString();
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String trimContext(Form form) {
        if (form == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(OWUtil.trimContext(form.functor()));
        int n = 0;
        while (n < form.arity()) {
            stringBuffer.append(' ');
            stringBuffer.append(OWUtil.trimContext(form.arg(n)));
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String trimContext(Formula formula) {
        if (formula == null) {
            return null;
        }
        return OWUtil.trimContextFromStruct((Struct)formula);
    }

    public static String trimContext(Term term) {
        if (term instanceof Num || term instanceof Variable) {
            return term.toOWLString();
        }
        if (term instanceof ConstSymbol) {
            return OWUtil.trimContext(((ConstSymbol)term).name());
        }
        if (term instanceof Struct) {
            return OWUtil.trimContextFromStruct((Struct)term);
        }
        System.out.println("trimContext() invoked on unrecognized Term");
        System.out.println("  term:" + term + " class:" + term.getClass().getName());
        return term.toString();
    }

    private static String trimContextFromStruct(Struct struct) {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(OWUtil.trimContext(struct.functor()));
        int n = struct.length();
        int n2 = 1;
        while (n2 <= n) {
            stringBuffer.append(' ');
            stringBuffer.append(OWUtil.trimContext(struct.argAt(n2)));
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String[] varStringsInOrder(Form form) {
        ArrayList arrayList = new ArrayList();
        OWUtil.addVars(arrayList, form, null);
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = arrayList.get(n).toString();
            ++n;
        }
        return stringArray;
    }

    private static void addVars(ArrayList arrayList, Form form, OMSAnswers oMSAnswers) {
        int n = form.arity();
        int n2 = 0;
        while (n2 < n) {
            IVar iVar;
            OWL oWL = form.arg(n2);
            if (oWL instanceof Form) {
                OWUtil.addVars(arrayList, (Form)oWL, oMSAnswers);
            } else if (!(!(oWL instanceof IVar) || (iVar = (IVar)oWL).isAnonymous() || arrayList.contains(iVar) || oMSAnswers != null && oMSAnswers.getVarIndex((Object)iVar.toString()) == -1)) {
                arrayList.add(iVar);
            }
            ++n2;
        }
    }

    public static String[] varStringsInOrder(Form form, OMSAnswers oMSAnswers) {
        ArrayList arrayList = new ArrayList();
        OWUtil.addVars(arrayList, form, oMSAnswers);
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = arrayList.get(n).toString();
            ++n;
        }
        return stringArray;
    }

    public static boolean isGround(Form form) {
        OWL oWL = form.functor();
        if (!OWUtil.isGround(oWL)) {
            return false;
        }
        int n = form.arity();
        int n2 = 0;
        while (n2 < n) {
            if (!OWUtil.isGround(form.arg(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isGround(OWL oWL) {
        if (oWL instanceof IVar) {
            return false;
        }
        return !(oWL instanceof Form) || OWUtil.isGround((Form)oWL);
    }

    public static OWL toOWL(String string) throws SyntaxError {
        OWL oWL = null;
        try {
            oWL = new OWLParser(new StringReader(string)).readExpr();
        }
        catch (IOException iOException) {
            oWL = null;
        }
        return oWL;
    }

    public static String toBriefString(Term term) {
        Rule rule;
        if (term instanceof QString) {
            String string = ((QString)term).value();
            return '\"' + OWUtil.toBriefString(string) + '\"';
        }
        if (term instanceof Rule && (rule = (Rule)term).anteSize() == 0) {
            return OWUtil.toBriefString((Struct)rule.conclusion());
        }
        if (term instanceof Struct) {
            return OWUtil.toBriefString((Struct)term);
        }
        return term.toOWLString();
    }

    public static String currentTime() {
        int n = (int)(System.currentTimeMillis() / 1000L % 86400L);
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        int n4 = n -= n3 * 60;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append(':');
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append(':');
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    public static void filterStackTrace(Throwable throwable, String string) {
        System.out.println("filtered stack trace:");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        String string2 = stringWriter.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string) == -1) continue;
            System.out.println(string3);
        }
    }

    public static void shallowStackTrace(Throwable throwable, int n) {
        System.out.print("shallow stack trace:  ");
        if (n == 0) {
            System.out.println();
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        String string = stringWriter.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n2 = 0;
        while (n2 < n && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            System.out.println(string2);
            ++n2;
        }
    }

    public static String toBriefString(Struct struct) {
        StringBuffer stringBuffer = new StringBuffer();
        if (struct.length() == 0) {
            stringBuffer.append('(');
            stringBuffer.append(OWUtil.toBriefString(struct.functor()));
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        stringBuffer.append('(');
        stringBuffer.append(OWUtil.toBriefString(struct.functor()));
        int n = struct.length();
        int n2 = 1;
        while (n2 <= n) {
            stringBuffer.append(' ').append(OWUtil.toBriefString(struct.argAt(n2)));
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String toBriefString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringUtils.replaceChar(stringBuffer, '\n', newLineStr);
        if (stringBuffer.length() <= 20) {
            return stringBuffer.toString();
        }
        stringBuffer.replace(17, stringBuffer.length(), "...");
        return stringBuffer.toString();
    }

    public static void fixNewlinesAndPrint(String string) {
        OWUtil.fixNewlinesAndPrint(string, System.out);
    }

    public static void fixNewlinesAndPrint(String string, PrintStream printStream) {
        if (string == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(10, n)) != -1) {
            printStream.println(string.substring(n, n2));
            n = n2 + 1;
        }
        if (n < string.length()) {
            printStream.print(string.substring(n));
        }
    }

    public static String fixNewlines(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(10, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(System.getProperty("line.separator"));
            n = n2 + 1;
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static void printInField(Object object, int n) {
        System.out.print(OWUtil.stringInField(object, n));
    }

    public static String stringInField(Object object, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(object.toString());
        int n3 = n2 = stringBuffer.length();
        while (n3 < n) {
            stringBuffer.append(' ');
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String stringReplaceAll(String string, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("oldStr cannot be null or empty");
        }
        int n = string2.length();
        if (n == 0) {
            throw new IllegalArgumentException("oldStr cannot be null or empty");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3));
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n2 = n3 + n;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

