/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.module;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.module.Relation;
import com.ow.gui.iode.module.RelationsViewList;
import com.ow.gui.iode.module.RelationsViewTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

class RelationsView
extends JPanel {
    JSplitPane split;
    JComponent leftComponent;
    IODEHTMLPane resultsPane;
    RelationsViewList relationList;
    RelationsViewTree relationTree;
    JCheckBox sortByPropButton;
    QManager qmgr;
    Relation lastSelected;
    OWL[] props;
    OWL target;
    boolean refreshList;
    boolean refreshTree;

    public RelationsView(OWL oWL, OWL oWL2, QManager qManager) {
        this.qmgr = qManager;
        this.sortByPropButton = new JCheckBox("Sort by Property");
        this.sortByPropButton.setSelected(true);
        this.resultsPane = new IODEHTMLPane();
        this.split = new JSplitPane();
        this.split.setRightComponent(new JScrollPane(this.resultsPane));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.sortByPropButton);
        this.add(this.split);
        this.addWiring();
        this.changeDisplay(oWL, oWL2, qManager);
    }

    private void addWiring() {
        this.sortByPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelationsView.this.refreshLeftPane(RelationsView.this.qmgr);
            }
        });
        if (this.relationList != null) {
            this.addWiringToList();
        }
        if (this.relationTree != null) {
            this.addWiringToTree();
        }
    }

    private void addWiringToList() {
        this.relationList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Relation relation = (Relation)RelationsView.this.relationList.getSelectedValue();
                if (relation == null) {
                    return;
                }
                if (relation == RelationsView.this.lastSelected) {
                    return;
                }
                RelationsView.this.lastSelected = relation;
                String string = RelationsView.this.allValues(RelationsView.this.lastSelected, RelationsView.this.target, RelationsView.this.qmgr);
                RelationsView.this.resultsPane.setText(string, RelationsView.this.qmgr);
            }
        });
    }

    private void addWiringToTree() {
        this.relationTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (treeSelectionEvent == null) {
                    return;
                }
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    return;
                }
                Object object = treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                if (object instanceof DefaultMutableTreeNode) {
                    object = ((DefaultMutableTreeNode)object).getUserObject();
                }
                if (object instanceof Relation) {
                    RelationsView.this.lastSelected = (Relation)object;
                    String string = RelationsView.this.allValues(RelationsView.this.lastSelected, RelationsView.this.target, RelationsView.this.qmgr);
                    RelationsView.this.resultsPane.setText(string, RelationsView.this.qmgr);
                } else {
                    RelationsView.this.resultsPane.setText("");
                }
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    protected void changeDisplay(OWL oWL, OWL oWL2, QManager qManager) {
        this.target = oWL2;
        this.qmgr = qManager;
        this.props = qManager.functionQuery("RootCtx.isaAsserted", oWL2);
        this.refreshTree = true;
        this.refreshList = true;
        this.refreshLeftPane(qManager);
        this.resultsPane.setText("");
        this.lastSelected = null;
    }

    private void refreshLeftPane(QManager qManager) {
        JComponent jComponent;
        JComponent jComponent2 = jComponent = this.sortByPropButton.isSelected() ? this.getTree(this.target, this.props, qManager) : this.getList(this.target, this.props, qManager);
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = new JScrollPane(jComponent);
        this.split.setLeftComponent(this.leftComponent);
        if (jComponent == this.relationTree) {
            this.relationTree.refreshContextDisplay();
        }
    }

    public JList getList(OWL oWL, OWL[] oWLArray, QManager qManager) {
        if (this.refreshList) {
            if (this.relationList == null) {
                this.relationList = new RelationsViewList(oWL, oWLArray, qManager);
                this.addWiringToList();
            } else {
                this.relationList.setData(oWL, oWLArray, this.lastSelected, qManager);
            }
            this.refreshList = false;
        }
        return this.relationList.getJList();
    }

    public JTree getTree(OWL oWL, OWL[] oWLArray, QManager qManager) {
        if (this.refreshTree) {
            if (this.relationTree == null) {
                this.relationTree = new RelationsViewTree(oWL, oWLArray, qManager);
                this.addWiringToTree();
            } else {
                this.relationTree.setData(oWL, oWLArray, this.lastSelected, qManager);
            }
            this.refreshTree = false;
        }
        return this.relationTree;
    }

    public String allValues(Relation relation, OWL oWL, QManager qManager) {
        StringBuffer stringBuffer = new StringBuffer(IODEHTMLPane.markUpSymbols(relation.getForm()) + "<br>&nbsp;");
        int n = relation.getArity();
        OWL[][] oWLArray = qManager.query_Safe(relation.getForm());
        OWL[] oWLArray2 = new OWL[n];
        oWLArray2[relation.which - 1] = oWL;
        if (oWLArray == null) {
            stringBuffer.append(n == 1 ? "evaluates as false." : "returns no answers.");
        } else if (oWLArray.length == 0) {
            stringBuffer.append("evaulates as true.");
        } else {
            stringBuffer.append("returns ");
            stringBuffer.append(oWLArray.length);
            stringBuffer.append(oWLArray.length == 1 ? " answer:<br>" : " answers:<br>");
            int n2 = 0;
            while (n2 < oWLArray.length) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < oWLArray[n2].length) {
                    if (n3 == relation.which - 1) {
                        // empty if block
                    }
                    int n5 = ++n3;
                    ++n3;
                    oWLArray2[n5] = oWLArray[n2][n4];
                    ++n4;
                }
                Form form = new Form(relation.me, oWLArray2);
                stringBuffer.append(IODEHTMLPane.markUpSymbols(form));
                stringBuffer.append("<br>");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    static void addParent(Object object, ArrayList arrayList, QManager qManager) {
        OWL[] oWLArray = qManager.functionQuery("RootCtx.sup", OWL.makeOWL(object));
        int n = 0;
        while (n < oWLArray.length) {
            if (!arrayList.contains(oWLArray[n])) {
                arrayList.add(oWLArray[n]);
            }
            ++n;
        }
    }
}

