/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.module;

import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.GUtil;
import com.ow.gui.iode.OWLRepresentable;
import com.ow.gui.iode.QManager;
import java.io.Serializable;

public class Relation
implements Serializable,
Comparable,
OWLRepresentable {
    final OWL me;
    final int arity;
    final int which;
    final OWL target;
    final String stringRep;
    final Form form;

    Relation(OWL oWL, int n, OWL oWL2, QManager qManager) {
        this.me = oWL;
        this.which = n;
        this.arity = qManager.getArity(oWL);
        this.target = oWL2;
        this.form = this.makeForm();
        this.stringRep = this.form.toString();
    }

    public int getArity() {
        return this.arity;
    }

    public OWL getRelation() {
        return this.me;
    }

    public Form getForm() {
        return this.form;
    }

    public String toString() {
        return this.stringRep;
    }

    public boolean equals(Object object) {
        if (object instanceof Relation) {
            Relation relation = (Relation)object;
            boolean bl = this.me.equals(relation.me) && this.which == relation.which;
            return bl;
        }
        return false;
    }

    private Form makeForm() {
        if (this.arity == -2) {
            return new Form(this.me, (OWL)new Symbol("..."));
        }
        OWL[] oWLArray = new OWL[this.arity];
        int n = 0;
        while (n < this.arity) {
            oWLArray[n] = n == this.which - 1 ? this.target : new IVar("?" + (n + 1));
            ++n;
        }
        return new Form(this.me, oWLArray);
    }

    public OWL getOWLRepresentation() {
        return this.form;
    }

    public int compareTo(Object object) {
        OWL oWL = this.me;
        OWL oWL2 = ((Relation)object).me;
        if (oWL instanceof Symbol && oWL2 instanceof Symbol) {
            return GUtil.compare((Symbol)oWL, (Symbol)oWL2);
        }
        return oWL.toString().compareTo(oWL2.toString());
    }
}

