/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.module;

import com.kb.oms.OMSAnswers;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.Signature;
import com.ow.gui.iode.module.PropRelList;
import com.ow.gui.iode.module.PropRelTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;

class PropRelView
extends JPanel {
    private static final IVar RelVar = new IVar("?Rel");
    private static final IVar ArgVar = new IVar("?Arg");
    private static final OWL[] emptyOWLarray = new OWL[0];
    PropRelList relList;
    PropRelTree relTree;
    JCheckBox sortByPropButton = new JCheckBox("Sort by Property");
    JScrollPane mainPane;
    OWL target;
    OWL[] props;
    HashMap rels;
    boolean refreshList;
    boolean refreshTree;

    public PropRelView(OWL oWL, OWL oWL2, QManager qManager) {
        this.sortByPropButton.setSelected(true);
        this.sortByPropButton.setToolTipText("Group relations by the specific property they apply to.");
        this.mainPane = new JScrollPane();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.sortByPropButton);
        this.add(this.mainPane);
        this.addWiring();
        this.changeDisplay(oWL, oWL2, qManager);
    }

    private void addWiring() {
        this.sortByPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropRelView.this.refreshPane();
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    protected void changeDisplay(OWL oWL, OWL oWL2, QManager qManager) {
        this.target = oWL2;
        this.buildPropsList(qManager);
        this.buildRelsMap(qManager);
        this.refreshTree = true;
        this.refreshList = true;
        this.refreshPane();
    }

    private void buildPropsList(QManager qManager) {
        ArrayList<OWL> arrayList = new ArrayList<OWL>();
        arrayList.add(this.target);
        int n = 0;
        while (n < arrayList.size()) {
            OWL oWL = (OWL)arrayList.get(n);
            OWL[] oWLArray = qManager.getSupertypes(oWL);
            int n2 = 0;
            while (n2 < oWLArray.length) {
                if (!arrayList.contains(oWLArray[n2])) {
                    arrayList.add(oWLArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        this.props = arrayList.toArray(emptyOWLarray);
    }

    private void buildRelsMap(QManager qManager) {
        this.rels = new HashMap();
        int n = 0;
        while (n < this.props.length) {
            OMSAnswers oMSAnswers = qManager.getAnswers_Safe(new Form("RootCtx.argProp", (OWL)RelVar, (OWL)ArgVar, this.props[n]));
            if (oMSAnswers != null && oMSAnswers.numAnswers() > 0) {
                Object object;
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>(oMSAnswers.numAnswers());
                int n2 = 0;
                while (n2 < oMSAnswers.numAnswers()) {
                    object = oMSAnswers.answer(n2, (Object)RelVar.toString());
                    if (!arrayList.contains(object)) {
                        arrayList.add((Object[])object);
                    }
                    ++n2;
                }
                object = new Signature[arrayList.size()];
                int n3 = 0;
                while (n3 < ((Signature[])object).length) {
                    object[n3] = new Signature((OWL)arrayList.get(n3), qManager);
                    ++n3;
                }
                Arrays.sort(object);
                this.rels.put(this.props[n], object);
            }
            ++n;
        }
    }

    private void refreshPane() {
        JComponent jComponent = this.sortByPropButton.isSelected() ? this.getTree() : this.getList();
        this.mainPane.setViewportView(jComponent);
        if (jComponent == this.relTree) {
            this.relTree.refreshContextDisplay();
        }
        this.revalidate();
    }

    public JList getList() {
        if (this.refreshList) {
            if (this.relList == null) {
                this.relList = new PropRelList(this.target, this.props, this.rels);
            } else {
                this.relList.setData(this.target, this.props, this.rels);
            }
            this.refreshList = false;
        }
        return this.relList.getJList();
    }

    public JTree getTree() {
        if (this.refreshTree) {
            if (this.relTree == null) {
                this.relTree = new PropRelTree(this.target, this.props, this.rels);
            } else {
                this.relTree.setData(this.target, this.props, this.rels);
            }
            this.refreshTree = false;
        }
        return this.relTree;
    }
}

