/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.module;

import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.ow.gui.MalformedQueryException;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.IODEHTMLParser;
import com.ow.gui.iode.IODEThrowableDisplayer;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.hier.CycleException;
import com.ow.gui.iode.hier.SubHierView;
import com.ow.gui.iode.module.AnswerPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ExtentDisplay
extends JPanel {
    private static final String ToolTipTrue = "This relation can be viewed hierarchically.";
    private static final String ToolTipFalse = "This relation cannot be viewed hierarchically.";
    private static final String NO_EXT = "no_ext";
    private static final String TREE = "tree";
    private static final String TABLE = "table";
    private static final int maxArgs = 10;
    private static final IVar[] argVars;
    private static final String noExtentText = " cannot have its extent retrieved, because of its <a href=RootCtx.argMode>binding pattern</a>.";
    private static final Symbol boundSym;
    private static final Symbol nonBindingSym;
    private static final Symbol groundSym;
    AnswerPane answerPane = new AnswerPane();
    JCheckBox hierBox;
    SubHierView hierView = new SubHierView();
    CardLayout cards;
    JPanel cardPane;
    IODEHTMLPane noExtentPane;

    public ExtentDisplay() {
        super(new BorderLayout());
        this.hierView.setTitleVisible(false);
        this.noExtentPane = new IODEHTMLPane();
        JScrollPane jScrollPane = new JScrollPane(this.noExtentPane);
        this.cards = new CardLayout();
        this.cardPane = new JPanel(this.cards);
        this.cardPane.add((Component)this.answerPane, TABLE);
        this.cardPane.add((Component)this.hierView, TREE);
        this.cardPane.add((Component)jScrollPane, NO_EXT);
        this.hierBox = new JCheckBox("hierarchical view", false);
        this.hierBox.setToolTipText(ToolTipFalse);
        this.add((Component)this.hierBox, "North");
        this.add((Component)this.cardPane, "Center");
        this.cards.show(this.cardPane, TABLE);
        this.addWiring();
    }

    private void addWiring() {
        this.hierBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ExtentDisplay.this.toggleHierMode();
            }
        });
    }

    public void setTarget(OWL oWL, QManager qManager) {
        if (this.noExtent(oWL, qManager)) {
            this.noExtentPane.setText(IODEHTMLParser.markUpSymbols(oWL) + noExtentText);
            this.cards.show(this.cardPane, NO_EXT);
            this.setHierBoxState(false);
            return;
        }
        this.toggleHierMode();
        Form form = this.makeExtentQuery(oWL, qManager);
        this.answerPane.query(form, qManager);
        this.setHierModeEnableState(oWL, form, qManager);
    }

    private Form makeExtentQuery(OWL oWL, QManager qManager) {
        OWL[] oWLArray = qManager.getArgNames(oWL);
        OWL[] oWLArray2 = oWLArray == null || oWLArray.length == 0 ? new OWL[qManager.getArity(oWL)] : new OWL[oWLArray.length];
        int n = 0;
        while (n < oWLArray2.length) {
            oWLArray2[n] = oWLArray == null || oWLArray.length == 0 || oWLArray[n] == null ? argVars[n] : this.makeVar(oWLArray[n], argVars[n]);
            ++n;
        }
        return new Form(oWL, oWLArray2);
    }

    private IVar makeVar(OWL oWL, IVar iVar) {
        return oWL instanceof QuotedString ? new IVar(((QuotedString)oWL).text()) : iVar;
    }

    private void toggleHierMode() {
        String string = this.hierBox.isSelected() ? TREE : TABLE;
        this.cards.show(this.cardPane, string);
    }

    private void setHierModeEnableState(OWL oWL, Form form, QManager qManager) {
        if (this.maybeHierarchical(oWL, form, qManager)) {
            this.setHierBoxState(true);
            try {
                this.hierView.setData(oWL, this.answerPane.getAnswersNoCopy(), qManager);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setHierBoxState(false);
            }
            catch (CycleException cycleException) {
                this.setHierBoxState(false);
            }
        } else {
            this.disableHierMode();
        }
    }

    private void disableHierMode() {
        this.setHierBoxState(false);
        this.cards.show(this.cardPane, TABLE);
    }

    private void setHierBoxState(boolean bl) {
        this.hierBox.setEnabled(bl);
        this.hierBox.setToolTipText(bl ? ToolTipTrue : ToolTipFalse);
    }

    private boolean maybeHierarchical(OWL oWL, Form form, QManager qManager) {
        if (form.arity() != 2) {
            return false;
        }
        OWL[] oWLArray = qManager.getArgProps(oWL);
        return oWLArray[0].equals(oWLArray[1]);
    }

    private boolean noExtent(OWL oWL, QManager qManager) {
        try {
            if (qManager.booleanQuery(this.modeQuery(oWL, argVars[1], boundSym))) {
                return true;
            }
            if (qManager.booleanQuery(this.modeQuery(oWL, argVars[2], nonBindingSym))) {
                return true;
            }
            if (qManager.booleanQuery(this.modeQuery(oWL, argVars[3], groundSym))) {
                return true;
            }
        }
        catch (MalformedQueryException malformedQueryException) {
            new IODEThrowableDisplayer().handle(malformedQueryException);
            return true;
        }
        return false;
    }

    private Form modeQuery(OWL oWL, IVar iVar, Symbol symbol) {
        return new Form("RootCtx.argMode", oWL, (OWL)iVar, (OWL)symbol);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    static {
        boundSym = new Symbol("RootCtx.boundMC");
        nonBindingSym = new Symbol("RootCtx.nonBindingMC");
        groundSym = new Symbol("RootCtx.groundMC");
        argVars = new IVar[10];
        int n = 0;
        while (n < 10) {
            ExtentDisplay.argVars[n] = new IVar("?arg" + n);
            ++n;
        }
    }
}

