/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.module;

import com.kb.gui.TableSorter;
import com.kb.oms.ArityException;
import com.kb.oms.FlounderException;
import com.kb.oms.ModeException;
import com.kb.oms.OMSAnswers;
import com.kb.oms.SyntaxException;
import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.ow.gui.MalformedQueryException;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.IODETable;
import com.ow.gui.iode.IODETableSorter;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.module.AnswerModel;
import com.ow.util.OWUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AnswerPane
extends JScrollPane {
    AnswerModel answerModel = new AnswerModel();
    JTable answerTable;
    IODEHTMLPane messagePane;
    TableSorter sorter = new IODETableSorter(this.answerModel);

    AnswerPane() {
        this.answerTable = new IODETable(this.sorter);
        this.answerTable.setCellSelectionEnabled(true);
        this.answerTable.setSelectionMode(0);
        this.messagePane = new IODEHTMLPane();
        this.messagePane.setEditable(false);
        this.setViewportView(this.messagePane);
        this.addWiring();
    }

    private void addWiring() {
        this.sorter.addMouseListenerToHeaderInTable(this.answerTable);
    }

    public void query(Form form, QManager qManager) {
        OMSAnswers oMSAnswers = null;
        Exception exception = null;
        try {
            oMSAnswers = qManager.getAnswers(form);
            exception = null;
        }
        catch (MalformedQueryException malformedQueryException) {
            exception = malformedQueryException.getQueryException();
            oMSAnswers = null;
        }
        if (oMSAnswers != null && oMSAnswers.numAnswers() > 0) {
            this.answerModel.setData(oMSAnswers, form);
            this.setViewportView(this.answerTable);
        } else if (exception == null) {
            this.messagePane.setText(oMSAnswers == null ? (OWUtil.isGround(form) ? "False." : "No answers were found.") : "True.");
            this.setViewportView(this.messagePane);
        } else {
            this.setErrorMessage(exception, form);
        }
    }

    protected OWL[][] getAnswersNoCopy() {
        return this.answerModel.ans;
    }

    private void setErrorMessage(Exception exception, Form form) {
        String string = null;
        string = exception instanceof ArityException ? "At least one of the relations in your query was used with the wrong number of arguments." : (exception instanceof ModeException ? "At least one of the relations in your query was used with the wrong binding pattern.  (Some arguments of some arguments must be variables; some must be constants; etc.)" : (exception instanceof SyntaxException ? "This query has the wrong syntax (misplaced parentheses, etc.)." : (exception instanceof FlounderException ? "This query is <i>floundering</i> - it has a free variable inside a negated clause.  You need to remove that variable, or restrict it in some way, perhaps by using it in a positive clause." : "I have no idea what's wrong!")));
        this.messagePane.setText(string + "  Check the query and try again.<br>\n" + "<br>\nMore detail from the server:<br>\n" + exception.toString());
        this.setViewportView(this.messagePane);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }
}

