/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.hier;

import com.ow.gui.Typematic;
import com.ow.gui.iode.hier.HierNode;
import com.ow.gui.iode.hier.SuperHierList;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class SuperHierView
extends JPanel {
    JLabel title;
    SuperHierList superList;
    HierNode root;

    protected SuperHierView(HierNode hierNode) {
        this.root = hierNode;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.superList = new SuperHierList(this.root);
        new Typematic(this.superList);
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setTitle();
        this.add("North", this.title);
        this.add("Center", new JScrollPane(this.superList));
    }

    protected HierNode getSelectedHierNode() {
        return (HierNode)this.superList.getSelectedValue();
    }

    public boolean hasFocus() {
        return this.superList.hasFocus();
    }

    protected void setRoot(HierNode hierNode) {
        this.root = hierNode;
        this.setTitle();
        this.superList.setRoot(hierNode);
        this.revalidate();
    }

    protected void refresh() {
        this.superList.refresh();
    }

    protected SuperHierList getSuperHierList() {
        return this.superList;
    }

    private void setTitle() {
        if (this.root == null) {
            this.title.setText("--");
        } else if (this.root.isMetaroot()) {
            this.title.setText("--");
        } else {
            this.title.setText("Terms above:");
        }
    }
}

