/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.hier;

import com.kb.owl.OWL;
import com.ow.gui.Typematic;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.hier.CycleException;
import com.ow.gui.iode.hier.HierNode;
import com.ow.gui.iode.hier.SubHierTree;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SubHierView
extends JPanel {
    JLabel title;
    SubHierTree subTree;
    HierNode root;
    boolean titleVisible = true;
    JScrollPane scroller;

    public SubHierView() {
        this(HierNode.nullNode);
    }

    protected SubHierView(HierNode hierNode) {
        this.root = hierNode;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.subTree = new SubHierTree(this.root);
        new Typematic(this.subTree);
        this.scroller = new JScrollPane(this.subTree);
        this.title = new JLabel();
        this.title.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setTitle();
        this.add("North", this.title);
        this.add("Center", this.scroller);
    }

    public void setData(OWL oWL, OWL[][] oWLArray, QManager qManager) throws IllegalArgumentException, CycleException {
        HierNode.setExtent(oWL, oWLArray, qManager);
        this.setRoot(HierNode.getRoot(oWL, qManager));
    }

    public void setTitleVisible(boolean bl) {
        if (this.titleVisible == bl) {
            return;
        }
        this.titleVisible = bl;
        if (this.titleVisible) {
            this.add("North", this.title);
        } else {
            this.remove(this.title);
        }
        this.revalidate();
    }

    protected HierNode getSelectedHierNode() {
        return this.subTree.getSelectedHierNode();
    }

    public boolean hasFocus() {
        return this.subTree.hasFocus();
    }

    protected void setRoot(HierNode hierNode) {
        this.root = hierNode;
        this.setTitle();
        this.subTree.setRoot(hierNode);
    }

    protected SubHierTree refresh() {
        this.subTree.refresh();
        this.subTree = new SubHierTree(this.root);
        new Typematic(this.subTree);
        this.scroller.setViewportView(this.subTree);
        return this.subTree;
    }

    protected SubHierTree getSubHierTree() {
        return this.subTree;
    }

    private void setTitle() {
        this.title.setText(this.root == null ? "--" : "Terms below:");
    }
}

