/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.hier;

import com.kb.owl.OWL;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.hier.CycleException;
import com.ow.gui.iode.hier.HierNode;
import com.ow.gui.iode.hier.SubHierView;
import com.ow.gui.iode.hier.SuperHierView;
import javax.swing.JSplitPane;

public class IODEHierView
extends JSplitPane {
    SubHierView subView;
    SuperHierView superView;
    OWL relation;
    QManager qmgr;

    public IODEHierView() {
        this(null, null, null);
    }

    public IODEHierView(OWL oWL, OWL oWL2, QManager qManager) {
        super(1);
        HierNode hierNode = HierNode.getHierNode(oWL2, oWL, qManager);
        this.superView = new SuperHierView(hierNode);
        this.subView = new SubHierView(hierNode);
        this.setLeftComponent(this.superView);
        this.setRightComponent(this.subView);
        this.relation = oWL;
        this.qmgr = qManager;
    }

    public HierNode getSelectedHierNode() {
        if (this.subView.hasFocus()) {
            return this.subView.getSelectedHierNode();
        }
        if (this.superView.hasFocus()) {
            return this.superView.getSelectedHierNode();
        }
        return null;
    }

    public static void refresh(OWL oWL, OWL oWL2, QManager qManager) {
        HierNode hierNode = HierNode.getHierNode(oWL, oWL2, qManager);
        if (hierNode != null) {
            hierNode.refresh();
        }
    }

    public static void removeData(OWL oWL, QManager qManager) {
        HierNode.removeRelation(oWL, qManager);
    }

    public void setRoot(OWL oWL, QManager qManager) {
        this.qmgr = qManager;
        this.setRoot(HierNode.getHierNode(oWL, this.relation, qManager));
    }

    protected void setRoot(HierNode hierNode) {
        this.subView.setRoot(hierNode);
        this.superView.setRoot(hierNode);
    }

    public void setData(OWL oWL, OWL[][] oWLArray, QManager qManager) throws IllegalArgumentException, CycleException {
        HierNode.setExtent(oWL, oWLArray, qManager);
        this.relation = oWL;
        this.qmgr = qManager;
        this.setRoot(HierNode.getRoot(oWL, qManager));
    }

    public void resetToPreferredSizes() {
        double d;
        double d2 = this.getTopComponent().getPreferredSize().getHeight();
        double d3 = d2 + (d = this.getBottomComponent().getPreferredSize().getHeight());
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        this.setDividerLocation(d2 / d3);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.resetToPreferredSizes();
    }
}

