/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.hier;

import com.kb.gui.Util;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.iode.IODEHTMLParser;
import com.ow.gui.iode.OWLRepresentable;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.hier.CycleException;
import com.ow.util.TrivialComparator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class HierNode
implements TreeNode,
Serializable,
OWLRepresentable {
    static HashMap qmgrToNodeMap = new HashMap();
    static HashMap qmgrToRootMap = new HashMap();
    static HierNode nullNode = new HierNode(null, null, null);
    OWL term;
    OWL relation;
    HierNode[] subs;
    HierNode[] supers;
    QManager qmgr;

    private HierNode(OWL oWL, OWL oWL2, QManager qManager) {
        this.term = oWL;
        this.relation = oWL2;
        this.qmgr = qManager;
    }

    public static HierNode getHierNode(OWL oWL, OWL oWL2, QManager qManager) {
        if (oWL == null || oWL2 == null || qManager == null) {
            return nullNode;
        }
        HierNode hierNode = null;
        HashMap hashMap = HierNode.getNodeMap(qManager);
        ArrayList arrayList = (ArrayList)hashMap.get(oWL);
        if (arrayList == null) {
            hierNode = HierNode.createHierNode(oWL, oWL2, qManager, hashMap);
        } else {
            int n = 0;
            boolean bl = false;
            HierNode hierNode2 = null;
            while (n < arrayList.size() && !bl) {
                hierNode2 = (HierNode)arrayList.get(n);
                boolean bl2 = bl = hierNode2.getRelation() == oWL2;
                if (bl) continue;
                ++n;
            }
            hierNode = bl ? hierNode2 : HierNode.createHierNode(oWL, oWL2, qManager, hashMap);
        }
        return hierNode;
    }

    private static HierNode createHierNode(OWL oWL, OWL oWL2, QManager qManager, HashMap hashMap) {
        HierNode hierNode = new HierNode(oWL, oWL2, qManager);
        HierNode.addHierNode(hierNode, hashMap);
        return hierNode;
    }

    private static void addHierNode(HierNode hierNode, HashMap hashMap) {
        OWL oWL = hierNode.getTerm();
        ArrayList<HierNode> arrayList = (ArrayList<HierNode>)hashMap.get(oWL);
        if (arrayList == null) {
            arrayList = new ArrayList<HierNode>();
            hashMap.put(oWL, arrayList);
        }
        arrayList.add(hierNode);
    }

    protected static void setExtent(OWL oWL, OWL[][] oWLArray, QManager qManager) throws IllegalArgumentException, CycleException {
        HierNode hierNode;
        Object object;
        Object object2;
        Object object3;
        if (oWLArray == null || oWLArray.length == 0) {
            throw new IllegalArgumentException("answer set must be non-null and non-empty");
        }
        int n = oWLArray.length;
        HashMap hashMap = new HashMap(n);
        HashMap hashMap2 = new HashMap(n);
        HashMap hashMap3 = new HashMap(n);
        HashMap hashMap4 = new HashMap(n);
        HashSet<Object> hashSet = new HashSet<Object>(n);
        int n2 = 0;
        while (n2 < oWLArray.length) {
            object3 = oWLArray[n2];
            if (object3 == null || ((OWL[])object3).length != 2) {
                throw new IllegalArgumentException("answer set must have exactly two columns");
            }
            object2 = object3[1];
            object = object3[0];
            if (object2.equals(object)) {
                throw new CycleException((OWL)object2);
            }
            HierNode.addToTCSet(hashMap3, (OWL)object2, (OWL)object);
            HierNode.addToTCSet(hashMap4, (OWL)object, (OWL)object2);
            HierNode.addToSet(hashMap, (OWL)object2, (OWL)object);
            HierNode.addToSet(hashMap2, (OWL)object, (OWL)object2);
            hashSet.add(object2);
            hashSet.add(object);
            ++n2;
        }
        HierNode.removeRelation(oWL, qManager);
        object3 = new ArrayList();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (OWL)object2.next();
            hierNode = HierNode.getHierNode((OWL)object, oWL, qManager);
            Set set = (Set)hashMap2.get(object);
            Set set2 = (Set)hashMap.get(object);
            hierNode.supers = HierNode.makeHierNodeArray(oWL, qManager, set);
            hierNode.subs = HierNode.makeHierNodeArray(oWL, qManager, set2);
            if (set != null && set.size() != 0) continue;
            ((ArrayList)object3).add(hierNode);
        }
        int n3 = ((ArrayList)object3).size();
        if (n3 == 1) {
            HierNode.getRootMap(qManager).put(oWL, ((ArrayList)object3).get(0));
        } else {
            hierNode = new HierNode(null, oWL, qManager);
            hierNode.subs = new HierNode[n3];
            hierNode.supers = new HierNode[0];
            int n4 = 0;
            while (n4 < n3) {
                hierNode.subs[n4] = (HierNode)((ArrayList)object3).get(n4);
                ++n4;
            }
            Arrays.sort(hierNode.subs, TrivialComparator.instance);
            HierNode.getRootMap(qManager).put(oWL, hierNode);
        }
    }

    private static HierNode[] makeHierNodeArray(OWL oWL, QManager qManager, Set set) {
        if (set == null) {
            return new HierNode[0];
        }
        int n = set.size();
        HierNode[] hierNodeArray = new HierNode[n];
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            hierNodeArray[n2] = HierNode.getHierNode((OWL)iterator.next(), oWL, qManager);
            ++n2;
        }
        Arrays.sort(hierNodeArray, TrivialComparator.instance);
        return hierNodeArray;
    }

    private static void addToSet(Map map, OWL oWL, OWL oWL2) {
        HashSet<OWL> hashSet = (HashSet<OWL>)map.get(oWL);
        if (hashSet == null) {
            hashSet = new HashSet<OWL>();
            map.put(oWL, hashSet);
        }
        hashSet.add(oWL2);
    }

    private static void addToTCSet(Map map, OWL oWL, OWL oWL2) throws CycleException {
        HashSet<OWL> hashSet = (HashSet<OWL>)map.get(oWL);
        Set set = (Set)map.get(oWL2);
        if (set != null && set.contains(oWL)) {
            throw new CycleException(oWL);
        }
        if (hashSet == null) {
            hashSet = new HashSet<OWL>();
            map.put(oWL, hashSet);
        }
        if (hashSet.contains(oWL2)) {
            return;
        }
        hashSet.add(oWL2);
        if (set != null) {
            hashSet.addAll(set);
        }
    }

    private static HashMap getNodeMap(QManager qManager) {
        return HierNode.getMap(qManager, qmgrToNodeMap);
    }

    private static HashMap getRootMap(QManager qManager) {
        return HierNode.getMap(qManager, qmgrToRootMap);
    }

    private static HashMap getMap(QManager qManager, HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.get(qManager);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            hashMap.put(qManager, hashMap2);
        }
        return hashMap2;
    }

    protected static HierNode getRoot(OWL oWL, QManager qManager) {
        return (HierNode)HierNode.getRootMap(qManager).get(oWL);
    }

    protected boolean isMetaroot() {
        return this != nullNode && this.term == null;
    }

    protected int getSubCount() {
        this.findSubsIfNeeded();
        return this.subs.length;
    }

    protected HierNode getSubAt(int n) {
        this.findSubsIfNeeded();
        return this.subs[n];
    }

    protected int getIndexOfSub(HierNode hierNode) {
        int n = this.subs.length - 1;
        while (n >= 0 && this.subs[n] != hierNode) {
            --n;
        }
        return n;
    }

    protected HierNode[] getSupers() {
        this.findSupersIfNeeded();
        HierNode[] hierNodeArray = new HierNode[this.supers.length];
        System.arraycopy(this.supers, 0, hierNodeArray, 0, this.supers.length);
        return hierNodeArray;
    }

    protected static void refreshAll(QManager qManager) {
        qmgrToNodeMap.put(qManager, new HashMap());
        qmgrToRootMap.put(qManager, new HashMap());
    }

    protected static void refreshAll(HierNode hierNode) {
        if (hierNode.isMetaroot() || hierNode == nullNode || hierNode.getSupers().length > 0) {
            return;
        }
        OWL oWL = hierNode.relation;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = HierNode.getNodeMap(hierNode.qmgr);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ArrayList arrayList2 = (ArrayList)hashMap.get(k);
            int n = arrayList2.size() - 1;
            while (n >= 0) {
                HierNode hierNode2 = (HierNode)arrayList2.get(n);
                if (hierNode2 == hierNode || hierNode2.relation.equals(oWL)) {
                    ((AbstractCollection)arrayList2).remove(hierNode2);
                }
                --n;
            }
            if (arrayList2.size() != 0) continue;
            arrayList.add(k);
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            hashMap.remove(arrayList.get(n));
            --n;
        }
        hierNode.refresh();
    }

    protected static void removeRelation(OWL oWL, QManager qManager) {
        HierNode hierNode = HierNode.getRoot(oWL, qManager);
        if (hierNode == null) {
            return;
        }
        HierNode.removeSubsRec(hierNode);
        HierNode.getRootMap(qManager).remove(oWL);
    }

    protected static void removeRelation(HierNode hierNode) {
        if (hierNode != null) {
            HierNode.removeRelation(hierNode.relation, hierNode.qmgr);
        }
    }

    private static void removeSubsRec(HierNode hierNode) {
        if (hierNode.subs != null) {
            int n = 0;
            while (n < hierNode.subs.length) {
                HierNode.removeSubsRec(hierNode.subs[n]);
                ++n;
            }
        }
        HierNode.removeNode(hierNode);
    }

    private static void removeNode(HierNode hierNode) {
        OWL oWL;
        if (hierNode.isMetaroot()) {
            return;
        }
        HashMap hashMap = HierNode.getNodeMap(hierNode.qmgr);
        ArrayList arrayList = (ArrayList)hashMap.get(oWL = hierNode.getTerm());
        if (arrayList == null) {
            return;
        }
        ((AbstractCollection)arrayList).remove(hierNode);
        if (arrayList.size() == 0) {
            hashMap.remove(oWL);
        }
        arrayList = (ArrayList)hashMap.get(oWL);
    }

    protected void refresh() {
        if (this != nullNode && !this.isMetaroot()) {
            this.supers = null;
            this.subs = null;
        }
    }

    public OWL getTerm() {
        return this.term;
    }

    protected OWL getRelation() {
        return this.relation;
    }

    public String toString() {
        if (this.isMetaroot()) {
            return "Roots of " + IODEHTMLParser.markUpSymbols(this.relation);
        }
        if (this.term != null) {
            return this.term.toString();
        }
        return "nullNode";
    }

    private void findSubsIfNeeded() {
        if (this.subs != null) {
            return;
        }
        TrivialComparator trivialComparator = TrivialComparator.instance;
        Object[] objectArray = this.qmgr.getSubs(this.term, this.relation);
        Arrays.sort(objectArray, trivialComparator);
        objectArray = Util.removeDupes(objectArray, trivialComparator);
        this.subs = new HierNode[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            OWL oWL = objectArray[n] instanceof OWL ? (OWL)objectArray[n] : new Symbol(objectArray[n].toString());
            this.subs[n] = HierNode.getHierNode(oWL, this.relation, this.qmgr);
            ++n;
        }
    }

    private void findSupersIfNeeded() {
        if (this.supers != null) {
            return;
        }
        TrivialComparator trivialComparator = TrivialComparator.instance;
        Object[] objectArray = this.qmgr.getSupers(this.term, this.relation);
        Arrays.sort(objectArray, trivialComparator);
        objectArray = Util.removeDupes(objectArray, trivialComparator);
        this.supers = new HierNode[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            OWL oWL = objectArray[n] instanceof OWL ? (OWL)objectArray[n] : new Symbol(objectArray[n].toString());
            this.supers[n] = HierNode.getHierNode(oWL, this.relation, this.qmgr);
            ++n;
        }
    }

    public OWL getOWLRepresentation() {
        return this.isMetaroot() ? null : this.term;
    }

    public TreeNode getChildAt(int n) {
        return this.getSubAt(n);
    }

    public int getChildCount() {
        return this.getSubCount();
    }

    public TreeNode getParent() {
        return null;
    }

    public int getIndex(TreeNode treeNode) {
        if (treeNode instanceof HierNode) {
            return this.getIndexOfSub((HierNode)treeNode);
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return this.getSubCount() == 0;
    }

    public Enumeration children() {
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                HierNode.this.findSubsIfNeeded();
                return this.index < HierNode.this.subs.length;
            }

            public Object nextElement() {
                return HierNode.this.subs[this.index++];
            }
        };
    }

    private static void showAllMappedNodes(HierNode hierNode) {
        HashMap hashMap = HierNode.getNodeMap(hierNode.qmgr);
        if (hashMap == null) {
            System.out.println("  null node map");
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            System.out.println("  " + k + " = " + HierNode.showNodeList((ArrayList)hashMap.get(k)));
        }
    }

    private static String showNodeList(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = 0;
        while (n < arrayList.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(HierNode.showHierNode((HierNode)arrayList.get(n)));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String showHierNode(HierNode hierNode) {
        return "(" + hierNode + "/" + hierNode.relation + ")";
    }

    static {
        HierNode.nullNode.supers = new HierNode[0];
        HierNode.nullNode.subs = HierNode.nullNode.supers;
    }
}

