/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.config;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.module.AbstractModule;
import com.ow.gui.iode.module.AssertionModule;
import com.ow.gui.iode.module.DataModule;
import com.ow.gui.iode.module.DocModule;
import com.ow.gui.iode.module.ExtentModule;
import com.ow.gui.iode.module.FunctorModule;
import com.ow.gui.iode.module.PropRelModule;
import com.ow.gui.iode.module.PropertyModule;
import com.ow.gui.iode.module.RelationsModule;
import com.ow.gui.iode.module.SentenceModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class BrowserSettings
implements Serializable {
    public static final int getModulesMapSizeCutoff = 100;
    HashMap typeModuleMap = new HashMap();

    public BrowserSettings() {
        this.temporaryPopulate();
    }

    private void temporaryPopulate() {
        Vector<AbstractModule> vector = new Vector<AbstractModule>();
        vector.add(new DocModule());
        vector.add(new RelationsModule());
        vector.add(new AssertionModule());
        this.addVecToTypeModuleMap("RootCtx.Top", vector);
        vector = new Vector();
        vector.add(new FunctorModule());
        vector.add(new DocModule());
        vector.add(new RelationsModule());
        vector.add(new AssertionModule());
        vector.add(new ExtentModule());
        this.addVecToTypeModuleMap("RootCtx.Relation", vector);
        vector = new Vector();
        vector.add(new DocModule());
        vector.add(new PropertyModule());
        vector.add(new PropRelModule());
        vector.add(new RelationsModule());
        vector.add(new AssertionModule());
        vector.add(new ExtentModule());
        this.addVecToTypeModuleMap("RootCtx.Property", vector);
        vector = new Vector();
        vector.add(new SentenceModule());
        this.addVecToTypeModuleMap("RootCtx.OWLSentence", vector);
    }

    private void addVecToTypeModuleMap(String string, Vector vector) {
        this.typeModuleMap.put(new Symbol(string), vector);
    }

    public Set getTypes() {
        return this.typeModuleMap.keySet();
    }

    public DataModule[][] getModules(OWL oWL, Browser browser) {
        ArrayList arrayList = this.typeModuleMap.size() > 100 ? this.getModuleTypesB(oWL, browser) : this.getModuleTypesA(oWL, browser);
        DataModule[][] dataModuleArray = new DataModule[arrayList.size()][];
        int n = 0;
        while (n < arrayList.size()) {
            Vector vector = (Vector)this.typeModuleMap.get(arrayList.get(n));
            dataModuleArray[n] = new DataModule[vector.size()];
            vector.toArray(dataModuleArray[n]);
            ++n;
        }
        return dataModuleArray;
    }

    private ArrayList getModuleTypesA(OWL oWL, Browser browser) {
        Set set = this.getTypes();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QManager qManager;
            OWL oWL2 = (OWL)iterator.next();
            if (!this.isa(oWL, oWL2, qManager = browser.getQManager())) continue;
            this.addToModuleTypes(arrayList, oWL2, qManager);
        }
        return arrayList;
    }

    private boolean isa(OWL oWL, OWL oWL2, QManager qManager) {
        if (oWL instanceof Form) {
            return oWL2.toString().equals("RootCtx.OWLSentence");
        }
        if (oWL2.toString().equals("RootCtx.Top")) {
            return true;
        }
        return qManager.isaXY(oWL, oWL2);
    }

    private void addToModuleTypes(ArrayList arrayList, OWL oWL, QManager qManager) {
        int n = arrayList.size() - 1;
        while (n >= 0) {
            if (qManager.subsumes((OWL)arrayList.get(n), oWL)) {
                arrayList.remove(n);
            }
            --n;
        }
        arrayList.add(oWL);
    }

    private ArrayList getModuleTypesB(OWL oWL, Browser browser) {
        QManager qManager = browser.getQManager();
        OWL[] oWLArray = qManager.getTypes(null, oWL);
        ArrayList<OWL> arrayList = new ArrayList<OWL>();
        Stack<OWL> stack = new Stack<OWL>();
        int n = 0;
        while (n < oWLArray.length) {
            stack.push(oWLArray[n]);
            ++n;
        }
        while (stack.size() > 0) {
            OWL oWL2 = (OWL)stack.pop();
            if (!this.continueSearch(oWL2, stack, qManager) || !this.continueSearch(oWL2, arrayList, qManager)) continue;
            if (this.typeModuleMap.get(oWL2) == null) {
                oWLArray = qManager.getParentTypes(oWL2);
                int n2 = 0;
                while (n2 < oWLArray.length) {
                    stack.push(oWLArray[n2]);
                    ++n2;
                }
                continue;
            }
            arrayList.add(oWL2);
        }
        return arrayList;
    }

    private boolean continueSearch(OWL oWL, Collection collection, QManager qManager) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            OWL oWL2 = (OWL)iterator.next();
            if (!oWL.equals(oWL2) && !qManager.subsumes(oWL, oWL2)) continue;
            return false;
        }
        return true;
    }
}

