/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.config;

import com.ow.gui.GUtil;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.IODE;
import com.ow.gui.iode.config.BrowserCfgTriPane;
import com.ow.gui.iode.config.BrowserSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BrowserConfig
extends JFrame {
    BrowserCfgTriPane triPane;
    JButton applyButton;
    JButton okButton;
    JButton cancelButton;
    Browser currentBrowser;
    BrowserSettings settings = new BrowserSettings();

    public BrowserConfig() {
        super("Browser Configuration");
        this.initGUI();
        this.addWiring();
    }

    private void initGUI() {
        this.triPane = new BrowserCfgTriPane(this);
        this.applyButton = GUtil.createButton("Apply", 'a');
        this.okButton = GUtil.createButton("Ok", 'o');
        this.cancelButton = GUtil.createButton("Cancel", 'c');
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.applyButton);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        Container container = this.getContentPane();
        container.add("Center", this.triPane);
        container.add("South", jPanel);
        ((Component)this).setSize(600, 400);
        GUtil.center(this);
    }

    private void addWiring() {
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserConfig.this.pressApply();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserConfig.this.pressOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserConfig.this.pressCancel();
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    public void setCurrentBrowser(Browser browser) {
        this.currentBrowser = browser;
        this.triPane.setCurrentBrowser(browser);
    }

    public Browser getCurrentBrowser() {
        return this.currentBrowser;
    }

    public BrowserSettings getSettings() {
        return this.settings;
    }

    private void pressApply() {
        Object[] objectArray = IODE.getWorkspace().getList();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Browser) {
                ((Browser)objectArray[n]).applyConfiguration(this);
            }
            ++n;
        }
    }

    private void pressOk() {
        this.pressApply();
        this.pressCancel();
    }

    private void pressCancel() {
        this.dispose();
    }
}

