/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.config;

import com.kb.owl.OWL;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.IODEList;
import com.ow.gui.iode.Target;
import com.ow.gui.iode.TargetOWL;
import com.ow.gui.iode.config.BrowserCfgTriPane;
import com.ow.gui.iode.config.BrowserConfig;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class BrowserCfgTypePane
extends JPanel {
    IODEList typeList;
    BrowserCfgTriPane triPane;

    public BrowserCfgTypePane(BrowserCfgTriPane browserCfgTriPane) {
        super(new BorderLayout());
        this.triPane = browserCfgTriPane;
        this.initGUI();
        this.addWiring();
    }

    private void initGUI() {
        this.typeList = new IODEList(this.makeTypeList());
        this.add("Center", new JScrollPane(this.typeList));
    }

    private void addWiring() {
    }

    private Vector makeTypeList() {
        Vector<String> vector = new Vector<String>(this.getBrowserConfig().getSettings().getTypes());
        String[] stringArray = this.getCurrentTargetTypes();
        int n = 0;
        while (n < stringArray.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        if (vector.size() == 0) {
            vector.add("RootCtx.Top");
        }
        return vector;
    }

    private BrowserConfig getBrowserConfig() {
        return this.triPane.getBrowserConfig();
    }

    private String[] getCurrentTargetTypes() {
        Browser browser = this.getBrowserConfig().getCurrentBrowser();
        if (browser == null) {
            return new String[0];
        }
        Target target = browser.getTarget();
        if (target == null || !(target instanceof TargetOWL)) {
            return new String[0];
        }
        OWL oWL = ((TargetOWL)target).getOWL();
        OWL[] oWLArray = browser.getQManager().getTypes(null, oWL);
        String[] stringArray = new String[oWLArray.length];
        int n = 0;
        while (n < oWLArray.length) {
            stringArray[n] = oWLArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    protected void setCurrentBrowser(Browser browser) {
        this.typeList.setListData(this.makeTypeList());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }
}

