/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode.config;

import com.ow.gui.iode.Browser;
import com.ow.gui.iode.config.BrowserCfgTypePane;
import com.ow.gui.iode.config.BrowserConfig;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

class BrowserCfgTriPane
extends JSplitPane {
    public static final String step1Help = "<html><b>Step 1:</b> Select a type shown at left. These are the types for which browser settings exist. Also shown is the type of the object currently browsed.";
    public static final String step2Help = "<html><b>Step 2:</b> Add and remove modules to be shown in a display for an object of that type.  Repeats are allowed. Select a module to configure it.";
    private static final String step1Card = "step1";
    private static final String step2Card = "step2";
    private static final String interfaceCard = "interface";
    BrowserConfig config;
    BrowserCfgTypePane typePane;
    JScrollPane modulePane;
    JScrollPane preferencePane;
    CardLayout rightLayout;
    CardLayout midRightLayout;
    JPanel rightPane;
    JPanel midRightPane;

    public BrowserCfgTriPane(BrowserConfig browserConfig) {
        super(1);
        this.config = browserConfig;
        this.initGUI();
    }

    private void initGUI() {
        this.temporaryComponents();
        this.typePane = new BrowserCfgTypePane(this);
        JLabel jLabel = new JLabel(step1Help, 0);
        JLabel jLabel2 = new JLabel(step2Help, 0);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        jLabel.setBorder(border);
        jLabel2.setBorder(border);
        this.rightLayout = new CardLayout();
        this.rightPane = new JPanel(this.rightLayout);
        this.rightPane.add((Component)jLabel2, step2Card);
        this.rightPane.add((Component)this.preferencePane, interfaceCard);
        this.rightLayout.show(this.rightPane, step2Card);
        JSplitPane jSplitPane = new JSplitPane(1, this.modulePane, this.rightPane);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setBorder(null);
        this.midRightLayout = new CardLayout();
        this.midRightPane = new JPanel(this.midRightLayout);
        this.midRightPane.add((Component)jLabel, step1Card);
        this.midRightPane.add((Component)jSplitPane, interfaceCard);
        this.midRightLayout.show(this.midRightPane, step1Card);
        this.setLeftComponent(this.typePane);
        this.setRightComponent(this.midRightPane);
        this.setDividerLocation(0.33);
        this.setResizeWeight(0.33);
    }

    private void temporaryComponents() {
        this.modulePane = new JScrollPane(new JLabel("module pane"));
        this.preferencePane = new JScrollPane(new JLabel("prefs pane"));
    }

    public BrowserConfig getBrowserConfig() {
        return this.config;
    }

    protected void setCurrentBrowser(Browser browser) {
        this.typePane.setCurrentBrowser(browser);
    }

    protected void typeSelected() {
        System.out.println("type selected");
        this.midRightLayout.next(this.midRightPane);
    }
}

