/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.oms.OMSAnswers;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.ow.gui.MalformedQueryException;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.Target;
import com.ow.util.TrivialComparator;
import java.util.Iterator;
import java.util.TreeSet;

public class TargetSearch
extends Target {
    final Symbol matchSym = new Symbol("RootCtx.getMatchingSymbol");
    String pattern;
    QManager qmgr;
    String htmlText;
    OWL query;

    public TargetSearch(String string, QManager qManager) {
        this.pattern = string;
        this.qmgr = qManager;
        this.htmlText = null;
        this.query = new Form(this.matchSym, (OWL)new QuotedString(string), (OWL)new IVar("Sym"));
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPatternAsSQL() {
        return this.pattern.replace('*', '%');
    }

    public String toString() {
        return this.pattern;
    }

    public OWL getQuery() {
        return this.query;
    }

    public String getHTMLText() {
        int n;
        if (this.htmlText != null) {
            return this.htmlText;
        }
        OMSAnswers oMSAnswers = null;
        try {
            oMSAnswers = this.qmgr.getAnswers(this.query);
        }
        catch (MalformedQueryException malformedQueryException) {
            malformedQueryException.printStackTrace();
            return "<html>An error occurred while trying to search.";
        }
        int n2 = n = oMSAnswers == null ? 0 : oMSAnswers.numAnswers();
        if (n == 0) {
            return "<html>Nothing matched <b>" + this.pattern + "</b>.";
        }
        TreeSet<OWL> treeSet = new TreeSet<OWL>(TrivialComparator.instance);
        int n3 = 0;
        while (n3 < n) {
            treeSet.add(oMSAnswers.answer(n3, 0));
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(n);
        stringBuffer.append(" match");
        if (n != 1) {
            stringBuffer.append("es");
        }
        stringBuffer.append(" found:<br>\n");
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("<sym>");
            stringBuffer.append(iterator.next());
            stringBuffer.append("</sym>");
            stringBuffer.append("<br>\n");
        }
        this.htmlText = stringBuffer.toString();
        return this.htmlText;
    }

    public void clearText() {
        this.htmlText = null;
    }
}

