/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.Symbol;
import com.ow.gui.ACCloseParenField;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.Target;
import com.ow.gui.iode.TargetOWL;
import com.ow.gui.iode.TargetSearch;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;

public class TargetIndicator
extends ACCloseParenField {
    Browser browser;

    public TargetIndicator(Browser browser) {
        super(Browser.targetCompletionList);
        this.browser = browser;
        this.setFont();
        this.addWiring();
    }

    private void addWiring() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TargetIndicator.this.getText();
                TargetIndicator.this.add(string);
                TargetIndicator.this.getBrowser().newTarget(TargetIndicator.this.makeTarget(string));
            }
        });
    }

    private void setFont() {
        Font font = this.getFont();
        this.setFont(new Font("Courier", font.getStyle(), font.getSize()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.browser);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.browser = (Browser)objectInputStream.readObject();
        this.addWiring();
    }

    protected void setTarget(Target target) {
        String string = target == null ? "" : target.toString();
        this.add(string);
        this.setText(string);
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    public void add(String string) {
        super.add(string);
    }

    protected void setBrowser(Browser browser) {
        this.browser = browser;
    }

    private Target makeTarget(String string) {
        if (this.isSearchPattern(string)) {
            return new TargetSearch(string, this.browser.getQManager());
        }
        if (string == null || string.equals("")) {
            return null;
        }
        return new TargetOWL(this.makeOWL(string));
    }

    private OWL makeOWL(String string) {
        OWLParser oWLParser = new OWLParser(new StringReader(string));
        OWL oWL = null;
        try {
            oWL = oWLParser.readExpr();
            if (oWL == OWLParser.eof || oWLParser.readExpr() != OWLParser.eof) {
                oWL = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oWL == null) {
            oWL = new Symbol(string);
        }
        return oWL;
    }

    private boolean isSearchPattern(String string) {
        boolean bl = this.isSearchPattern0(string);
        return bl;
    }

    private boolean isSearchPattern0(String string) {
        int n = 42;
        if (string.indexOf(n) == -1) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 = string.indexOf(n, n2)) != -1) {
            if ((n3 += this.countChars(string.substring(n2, n4), '\"')) % 2 == 0) {
                return true;
            }
            n2 = n4 + 1;
        }
        return false;
    }

    private int countChars(String string, char c) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(c, n2)) != -1) {
            ++n2;
            ++n;
        }
        return n;
    }
}

