/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.oms.OMSException;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SymbolsNotFoundException
extends OMSException {
    ArrayList symbols;

    public SymbolsNotFoundException(Symbol symbol) {
        super("symbol not found", (OWL)symbol);
        if (symbol == null) {
            throw new IllegalArgumentException("symbol must be non-null");
        }
        this.symbols = new ArrayList(1);
        this.symbols.add(symbol);
    }

    public SymbolsNotFoundException(Symbol[] symbolArray) {
        super("symbols not found", null);
        if (symbolArray == null) {
            throw new IllegalArgumentException("symbol list must be non-empty");
        }
        this.symbols = new ArrayList(symbolArray.length);
        int n = 0;
        while (n < symbolArray.length) {
            if (!this.symbols.contains(symbolArray[n])) {
                this.symbols.add(symbolArray[n]);
            }
            ++n;
        }
    }

    public Symbol[] getSymbols() {
        Symbol[] symbolArray = new Symbol[this.symbols.size()];
        return this.symbols.toArray(symbolArray);
    }

    public void addSymbols(SymbolsNotFoundException symbolsNotFoundException) {
        Iterator iterator = ((AbstractList)symbolsNotFoundException.symbols).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.symbols.contains(e)) continue;
            this.symbols.add(e);
        }
    }
}

