/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.GUtil;
import com.ow.gui.iode.IODEHTMLParser;
import com.ow.gui.iode.QManager;
import java.io.Serializable;

public class Signature
implements Comparable,
Serializable {
    private static final Symbol[] arities;
    private static final int maxArity = 5;
    private static final Symbol UnknownArgProp;
    final OWL relation;
    final int arity;
    String stringRep;
    final OWL[] argProps;

    public Signature(OWL oWL, QManager qManager) {
        this.relation = oWL;
        this.arity = qManager.getArity(oWL);
        this.argProps = this.arity > 0 ? qManager.getArgProps(oWL) : null;
        this.stringRep = this.makeStringRep();
    }

    private String makeStringRep() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IODEHTMLParser.markUpSymbols(this.relation));
        stringBuffer.append(": ");
        int n = 0;
        while (n < this.arity) {
            if (n > 0) {
                stringBuffer.append(" x ");
            }
            stringBuffer.append(IODEHTMLParser.markUpSymbols(this.argProps[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public OWL getRelation() {
        return this.relation;
    }

    public int getArity() {
        return this.arity;
    }

    public OWL getArgProp(int n) {
        return this.argProps[n - 1];
    }

    public String toString() {
        return this.stringRep;
    }

    public int compareTo(Object object) {
        OWL oWL = this.getRelation();
        OWL oWL2 = ((Signature)object).getRelation();
        if (oWL instanceof Symbol && oWL2 instanceof Symbol) {
            return GUtil.compare((Symbol)oWL, (Symbol)oWL2);
        }
        return oWL.toString().compareTo(oWL2.toString());
    }

    static {
        UnknownArgProp = new Symbol("UNKNOWN");
        arities = new Symbol[6];
        int n = 1;
        while (n <= 5) {
            Signature.arities[n] = new Symbol(n);
            ++n;
        }
    }
}

