/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.client.ConnectionFailure;
import com.kb.client.KBException;
import com.kb.kbddutil.KBProperties;
import com.kb.oms.OMSAPI;
import com.kb.oms.OMSAnswers;
import com.kb.oms.OMSException;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.kb.refs.OMSRefs;
import com.ow.gui.GUtil;
import com.ow.gui.MalformedQueryException;
import com.ow.gui.iode.IODEThrowableDisplayer;
import com.ow.gui.iode.SymbolsNotFoundException;
import com.ow.util.QueryCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class QManager
implements OMSRefs,
Serializable {
    public static final String iodePropPfx = "com.ow.iode.";
    public static final String dumpAnswersProp = "com.ow.iode.dumpAnswers";
    public static final boolean dumpAnswersDefault = false;
    public static boolean dumpAnswersFlag;
    public static final String exampleRemName = "RootCtx.exampleRem";
    public static final String limitationRemName = "RootCtx.limitationRem";
    public static final String referenceRemName = "RootCtx.referenceRem";
    public static final String systemRemName = "RootCtx.systemRem";
    static final int maxRange = 5;
    static Symbol[] integers;
    static final OWL[] emptyOWLArray;
    static final Symbol topSymbol;
    static final IVar Var;
    static final IVar IntVar;
    static final IVar PropVar;
    static final IVar NameVar;
    transient OMSAPI omsapi;
    transient QueryCache cache;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.omsapi.getURLString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        try {
            this.omsapi = new OMSAPI(string);
            this.cache = new QueryCache(this.omsapi);
        }
        catch (ConnectionFailure connectionFailure) {
            connectionFailure.printStackTrace();
            this.omsapi = null;
            this.cache = null;
        }
    }

    public QManager(OMSAPI oMSAPI) throws ConnectionFailure {
        this.omsapi = oMSAPI;
        this.cache = new QueryCache(oMSAPI);
    }

    public QManager() throws ConnectionFailure {
        this(new OMSAPI());
    }

    public OWL disambiguate(OWL oWL) throws SymbolsNotFoundException {
        if (oWL instanceof Form) {
            return this.disambiguate((Form)oWL);
        }
        if (oWL instanceof Symbol) {
            return this.disambiguate((Symbol)oWL);
        }
        return oWL;
    }

    public Form disambiguate(Form form) throws SymbolsNotFoundException {
        SymbolsNotFoundException symbolsNotFoundException = null;
        int n = form.arity();
        OWL[] oWLArray = new OWL[n + 1];
        try {
            oWLArray[0] = this.disambiguate(form.functor());
        }
        catch (SymbolsNotFoundException symbolsNotFoundException2) {
            if (symbolsNotFoundException == null) {
                symbolsNotFoundException = symbolsNotFoundException2;
            }
            symbolsNotFoundException.addSymbols(symbolsNotFoundException2);
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                oWLArray[n2 + 1] = this.disambiguate(form.arg(n2));
                if (oWLArray[n2 + 1] == null) {
                    oWLArray[n2 + 1] = form.arg(n2);
                }
            }
            catch (SymbolsNotFoundException symbolsNotFoundException3) {
                if (symbolsNotFoundException == null) {
                    symbolsNotFoundException = symbolsNotFoundException3;
                }
                symbolsNotFoundException.addSymbols(symbolsNotFoundException3);
            }
            ++n2;
        }
        if (symbolsNotFoundException != null) {
            throw symbolsNotFoundException;
        }
        return new Form(oWLArray);
    }

    public Symbol disambiguate(Symbol symbol) throws SymbolsNotFoundException {
        if (symbol.isInt() || symbol.isReal() || this.isInOntology(symbol)) {
            return symbol;
        }
        Symbol symbol2 = this.disambiguate(symbol.toString());
        if (symbol2 == null) {
            throw new SymbolsNotFoundException(symbol);
        }
        return symbol2;
    }

    public Symbol disambiguate(String string) {
        Symbol symbol = null;
        try {
            symbol = this.cache.disambiguateSymbol(string);
        }
        catch (KBException kBException) {
            new IODEThrowableDisplayer().handle(kBException);
        }
        return symbol;
    }

    public OWL[] getTypes(OWL oWL, OWL oWL2) {
        return this.getTypes(oWL2);
    }

    private OWL[] getTypes(OWL oWL) {
        return this.functionQuery("RootCtx.isaAsserted", oWL);
    }

    public OWL[] getParentTypes(OWL oWL) {
        return this.functionQuery("RootCtx.sup", oWL);
    }

    public OWL[] getSubtypes(OWL oWL) {
        return this.to1DArray(this.query("RootCtx.sup", (OWL)Var, oWL), 0);
    }

    public OWL[] getSupertypes(OWL oWL) {
        return this.functionQuery("RootCtx.sup", oWL);
    }

    public OWL[] getSubs(OWL oWL, OWL oWL2) {
        return this.to1DArray(this.query(oWL2, (OWL)Var, oWL), 0);
    }

    public OWL[] getSupers(OWL oWL, OWL oWL2) {
        return this.functionQuery(oWL2, oWL);
    }

    public int getArity(OWL oWL) {
        return this.getFirst("RootCtx.arity", oWL, -2);
    }

    public OWL[] getRemarks(OWL oWL) {
        return this.functionQuery("RootCtx.rem", oWL);
    }

    public OWL[] getSharedRemarks(OWL oWL) {
        OWL[] oWLArray = this.functionQuery("RootCtx.sharedRem", oWL);
        OWL[] oWLArray2 = new OWL[oWLArray.length];
        int n = 0;
        while (n < oWLArray2.length) {
            oWLArray2[n] = this.getFirst("RootCtx.rem", oWLArray[n], oWLArray[n]);
            ++n;
        }
        return oWLArray2;
    }

    public OWL getArgProp(OWL oWL, int n) {
        return this.getFirst("RootCtx.argProp", oWL, integers[n], null);
    }

    public OWL[] getArgProps(OWL oWL) {
        return this.getArgInfo(oWL, "RootCtx.argProp");
    }

    public OWL[] getArgNames(OWL oWL) {
        return this.getArgInfo(oWL, "RootCtx.argName");
    }

    private OWL[] getArgInfo(OWL oWL, String string) {
        OMSAnswers oMSAnswers = this.getAnswers_Safe(new Form(string, oWL, (OWL)IntVar, (OWL)PropVar));
        if (oMSAnswers == null) {
            return null;
        }
        int n = oMSAnswers.getVarIndex((Object)IntVar.toString());
        int n2 = oMSAnswers.getVarIndex((Object)PropVar.toString());
        int n3 = this.getArity(oWL);
        OWL[][] oWLArray = oMSAnswers.answersAsArray();
        OWL[] oWLArray2 = new OWL[n3];
        int n4 = 0;
        while (n4 < oWLArray.length) {
            int n5 = oWLArray[n4][n].intValue();
            oWLArray2[n5 - 1] = oWLArray[n4][n2];
            ++n4;
        }
        return oWLArray2;
    }

    public boolean isaXY(OWL oWL, OWL oWL2) {
        return this.booleanQuery("RootCtx.isa", oWL, oWL2);
    }

    public boolean subsumes(OWL oWL, OWL oWL2) {
        return this.booleanQuery("RootCtx.supTC", oWL2, oWL);
    }

    public OWL getFirst(String string, OWL oWL, OWL oWL2) {
        OWL[] oWLArray = this.functionQuery(string, oWL);
        return oWLArray.length != 0 ? oWLArray[0] : oWL2;
    }

    public OWL getFirst(String string, OWL oWL, OWL oWL2, OWL oWL3) {
        OWL[] oWLArray = this.functionQuery(string, oWL, oWL2);
        return oWLArray.length != 0 ? oWLArray[0] : oWL3;
    }

    public int getFirst(String string, OWL oWL, int n) {
        OWL[] oWLArray = this.functionQuery(string, oWL);
        if (oWLArray.length == 0) {
            return n;
        }
        OWL oWL2 = oWLArray[0];
        if (!(oWL2 instanceof Symbol)) {
            return n;
        }
        Symbol symbol = (Symbol)oWL2;
        return symbol.isInt() ? symbol.intValue() : n;
    }

    public String getDatabaseName() {
        return this.omsapi.getDatabaseName();
    }

    public QueryCache getQueryCache() {
        return this.cache;
    }

    public boolean isInOntology(Symbol symbol) {
        boolean bl = false;
        try {
            bl = this.cache.isInOntology(symbol);
        }
        catch (KBException kBException) {
            new IODEThrowableDisplayer().handle(kBException);
        }
        catch (OMSException oMSException) {
            new IODEThrowableDisplayer().handle(oMSException);
        }
        return bl;
    }

    public OWL[] getSentencesUsing(Symbol symbol) throws KBException {
        Form[] formArray = this.cache.getUses(symbol);
        OWL[] oWLArray = new OWL[formArray.length];
        int n = 0;
        while (n < formArray.length) {
            oWLArray[n] = this.cache.getSentence(formArray[n]);
            ++n;
        }
        return oWLArray;
    }

    public OWL[] to1DArray(OMSAnswers oMSAnswers, int n) {
        if (oMSAnswers == null) {
            return emptyOWLArray;
        }
        OWL[] oWLArray = new OWL[oMSAnswers.numAnswers()];
        int n2 = 0;
        while (n2 < oWLArray.length) {
            oWLArray[n2] = oMSAnswers.answer(n2, n);
            ++n2;
        }
        return oWLArray;
    }

    public void close() {
        try {
            this.omsapi.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OWL[] functionQuery(OWL oWL, OWL oWL2) {
        return this.to1DArray(this.query(oWL, oWL2, (OWL)Var), 0);
    }

    public OWL[] functionQuery(String string, OWL oWL) {
        return this.to1DArray(this.query(string, oWL, (OWL)Var), 0);
    }

    public OWL[] functionQuery(String string, OWL oWL, OWL oWL2) {
        return this.to1DArray(this.query(string, oWL, oWL2, (OWL)Var), 0);
    }

    public boolean booleanQuery(String string, OWL oWL, OWL oWL2) {
        OMSAnswers oMSAnswers = this.query(string, oWL, oWL2);
        return oMSAnswers != null;
    }

    public boolean booleanQuery(Form form) throws MalformedQueryException {
        OMSAnswers oMSAnswers = this.queryImpl(form);
        return oMSAnswers != null;
    }

    public OWL[][] query(OWL oWL) throws MalformedQueryException {
        OMSAnswers oMSAnswers = this.queryImpl(oWL);
        if (oMSAnswers != null) {
            return oMSAnswers.answersAsArray();
        }
        return null;
    }

    public OWL[][] query_Safe(OWL oWL) {
        OMSAnswers oMSAnswers = this.queryImpl_Safe(oWL);
        if (oMSAnswers != null) {
            return oMSAnswers.answersAsArray();
        }
        return null;
    }

    public OMSAnswers getAnswers(OWL oWL) throws MalformedQueryException {
        return this.queryImpl(oWL);
    }

    public OMSAnswers getAnswers_Safe(OWL oWL) {
        return this.queryImpl_Safe(oWL);
    }

    private OMSAnswers query(String string, OWL oWL, OWL oWL2) {
        return this.queryImpl_Safe(new Form(string, oWL, oWL2));
    }

    private OMSAnswers query(String string, OWL oWL, OWL oWL2, OWL oWL3) {
        return this.queryImpl_Safe(new Form(string, oWL, oWL2, oWL3));
    }

    private OMSAnswers query(OWL oWL, OWL oWL2, OWL oWL3) {
        return this.queryImpl_Safe(new Form(oWL, oWL2, oWL3));
    }

    private OMSAnswers query(OWL oWL, OWL oWL2, OWL oWL3, OWL oWL4) {
        return this.queryImpl_Safe(new Form(oWL, oWL2, oWL3, oWL4));
    }

    private OMSAnswers queryImpl(OWL oWL) throws MalformedQueryException {
        OMSAnswers oMSAnswers = null;
        if (dumpAnswersFlag) {
            System.out.println("Asking: " + oWL);
        }
        try {
            oMSAnswers = this.cache.ask(oWL);
        }
        catch (ConnectionFailure connectionFailure) {
            System.out.println("QManager: connection failure");
            oMSAnswers = null;
        }
        catch (KBException kBException) {
            System.out.println("QManager: query failure");
            oMSAnswers = null;
        }
        catch (OMSException oMSException) {
            throw new MalformedQueryException((Exception)((Object)oMSException));
        }
        this.debugDumpAnswers(oMSAnswers);
        return oMSAnswers;
    }

    private OMSAnswers queryImpl_Safe(OWL oWL) {
        OMSAnswers oMSAnswers = null;
        try {
            oMSAnswers = this.queryImpl(oWL);
        }
        catch (MalformedQueryException malformedQueryException) {
            new IODEThrowableDisplayer().handle(malformedQueryException);
            oMSAnswers = null;
        }
        return oMSAnswers;
    }

    private void debugDumpAnswers(OMSAnswers oMSAnswers) {
        if (!dumpAnswersFlag) {
            return;
        }
        if (oMSAnswers == null) {
            System.out.println("null answers object returned");
            return;
        }
        if (oMSAnswers.numAnswers() > 10) {
            System.out.println(oMSAnswers.numAnswers() + " answer sets returned");
            return;
        }
        System.out.print(oMSAnswers.numAnswers() + " returned: ");
        OWL[][] oWLArray = oMSAnswers.answersAsArray();
        int n = 0;
        while (n < oWLArray.length) {
            if (n > 0) {
                System.out.print(',');
            }
            System.out.print('(');
            int n2 = 0;
            while (n2 < oWLArray[n].length) {
                OWL oWL;
                if (n2 > 0) {
                    System.out.print(',');
                }
                if ((oWL = oWLArray[n][n2]) instanceof QuotedString) {
                    String string = ((QuotedString)oWL).text();
                    System.out.print('\"');
                    System.out.print(GUtil.dispString(string));
                    System.out.print('\"');
                } else {
                    System.out.print(oWL);
                }
                ++n2;
            }
            System.out.print(')');
            ++n;
        }
        System.out.println();
    }

    static {
        emptyOWLArray = new OWL[0];
        topSymbol = new Symbol("RootCtx.Top");
        Var = new IVar("?Var");
        IntVar = new IVar("?Int");
        PropVar = new IVar("?Prop");
        NameVar = new IVar("?Name");
        integers = new Symbol[5];
        int n = 0;
        while (n < 5) {
            QManager.integers[n] = new Symbol(n);
            ++n;
        }
        dumpAnswersFlag = KBProperties.getBoolean(dumpAnswersProp);
    }
}

