/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.ow.gui.iode.Browser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class PopupListener
extends MouseInputAdapter {
    Component glassPane;
    Container contentPane;
    JMenuBar menuBar;
    boolean inDrag = false;

    protected PopupListener(Browser browser) {
        this.glassPane = browser.getGlassPane();
        this.contentPane = browser.getContentPane();
        this.menuBar = browser.getJMenuBar();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, false);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, false, true);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent, true, true);
        this.inDrag = false;
    }

    private String getDate() {
        String string = new Date(System.currentTimeMillis()).toString();
        return string.substring(0, string.length());
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        boolean bl3 = false;
        Point point = mouseEvent.getPoint();
        Component component = null;
        Container container = this.contentPane;
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, this.contentPane);
        int n = mouseEvent.getID();
        if (point2.y < 0) {
            bl3 = true;
            container = this.menuBar;
            point2 = SwingUtilities.convertPoint(this.glassPane, point, this.menuBar);
            this.testForDrag(n);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, point2.x, point2.y)) == null) {
            if (bl2) {
                System.out.println("rME: " + this.getDate() + " comp is null");
            }
            return;
        }
        if (bl2) {
            System.out.println("rME: " + this.getDate() + " comp is a " + component.getClass().getName());
        }
        if (bl3 || this.inDrag) {
            Point point3 = SwingUtilities.convertPoint(this.glassPane, point, component);
            component.dispatchEvent(new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    private void testForDrag(int n) {
        if (n == 501) {
            this.inDrag = true;
        }
    }
}

