/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.ow.gui.iode.ContextSuppressor;
import com.ow.gui.iode.IODE;
import com.ow.gui.iode.IODETreeCellRenderer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IODETree
extends JTree {
    public IODETree() {
        this.initOther();
    }

    public IODETree(TreeNode treeNode) {
        super(treeNode);
        this.initOther();
    }

    public IODETree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        this.initOther();
    }

    public void setModel(TreeModel treeModel) {
        if (!(treeModel instanceof DefaultTreeModel)) {
            throw new IllegalArgumentException("IODETree can only use DefaultTreeModels");
        }
        super.setModel(treeModel);
    }

    private void initOther() {
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new IODETreeCellRenderer());
        this.addWiring();
    }

    private void addWiring() {
        IODE.getPopupManager().manage(this);
    }

    protected void setContextDisplayMode(boolean bl) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        TreePath treePath = this.getSelectionPath();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(defaultTreeModel.getRoot()));
        ArrayList<TreePath> arrayList = null;
        if (enumeration != null) {
            arrayList = new ArrayList<TreePath>();
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                arrayList.add(treePath2);
            }
        }
        defaultTreeModel.reload();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.expandPath((TreePath)arrayList.get(n));
                ++n;
            }
        }
        if (treePath != null) {
            this.setSelectionPath(treePath);
        }
    }

    public void refreshContextDisplay() {
        this.setContextDisplayMode(ContextSuppressor.getMode(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }
}

