/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.ow.gui.GUtil;
import com.ow.gui.iode.IODE;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

class IODESelectableListener
implements MouseListener {
    IODESelectableListener() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        this.selectItemAtPoint(mouseEvent.getPoint(), (Component)mouseEvent.getSource());
        this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void showPopup(Component component, int n, int n2) {
        Object object = GUtil.getSelectedItem(component);
        IODE.getPopupManager().showPopupMenu(object, component, n, n2);
    }

    private void selectItemAtPoint(Point point, Component component) {
        if (component instanceof JTable) {
            JTable jTable = (JTable)component;
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.columnAtPoint(point);
            if (n != -1 && n2 != -1) {
                jTable.setRowSelectionInterval(n, n);
                jTable.setColumnSelectionInterval(n2, n2);
            }
        } else if (!(component instanceof JTextComponent)) {
            if (component instanceof JList) {
                JList jList = (JList)component;
                jList.setSelectedIndex(jList.locationToIndex(point));
            } else if (component instanceof JTree) {
                JTree jTree = (JTree)component;
                TreePath treePath = jTree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (treePath != null) {
                    jTree.setSelectionPath(treePath);
                }
            } else {
                System.out.println("selectItemAtPoint found a " + component.getClass().getName());
            }
        }
    }
}

