/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.IODELinkListener;
import com.ow.gui.iode.IODESelectableListener;
import com.ow.gui.iode.Signature;
import com.ow.gui.iode.action.ViewTargetAction;
import com.ow.gui.iode.action.ViewTargetNewAction;
import com.ow.gui.iode.hier.HierNode;
import com.ow.gui.iode.module.Relation;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class IODEPopupManager {
    private static final ViewTargetAction viewAction = new ViewTargetAction();
    private static final ViewTargetNewAction viewNewAction = new ViewTargetNewAction();
    private static final IODESelectableListener selectableListener = new IODESelectableListener();
    private static final Action[] EmptyActionArray = new Action[0];

    public void manageAll(Component component) {
        this.manage(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.manageAll(componentArray[n]);
                ++n;
            }
        }
    }

    public void manage(Component component) {
        if (component instanceof IODEHTMLPane) {
            new IODELinkListener((IODEHTMLPane)component);
        } else if (component instanceof JList || component instanceof JTree || component instanceof JTable) {
            component.addMouseListener(selectableListener);
        }
    }

    public void showPopupMenu(HyperlinkEvent hyperlinkEvent, int n, int n2) {
        JPopupMenu jPopupMenu = this.makePopupMenu(hyperlinkEvent);
        jPopupMenu.pack();
        jPopupMenu.show((Component)hyperlinkEvent.getSource(), n, n2);
    }

    public void showPopupMenu(Object object, Component component, int n, int n2) {
        JPopupMenu jPopupMenu = this.makePopupMenu(object, component);
        jPopupMenu.pack();
        jPopupMenu.show(component, n, n2);
    }

    public JPopupMenu makePopupMenu(HyperlinkEvent hyperlinkEvent) {
        Symbol symbol = new Symbol(hyperlinkEvent.getDescription());
        Component component = (Component)hyperlinkEvent.getSource();
        Browser browser = Browser.forComponent(component);
        viewAction.setBrowser(browser);
        viewNewAction.setBrowser(browser);
        JPopupMenu jPopupMenu = new JPopupMenu("popup");
        jPopupMenu.add(viewAction.setTarget(symbol));
        jPopupMenu.add(viewNewAction.setTarget(symbol));
        return jPopupMenu;
    }

    public JPopupMenu makePopupMenu(Object object, Component component) {
        Action[] actionArray = this.getActions(object, component);
        JPopupMenu jPopupMenu = new JPopupMenu("popup");
        int n = 0;
        while (n < actionArray.length) {
            jPopupMenu.add(actionArray[n]);
            ++n;
        }
        return jPopupMenu;
    }

    private Action[] getActions(Object object, Component component) {
        if (object instanceof OWL) {
            return this.getActions((OWL)object, component);
        }
        if (object instanceof Relation) {
            return this.getActions((Relation)object, component);
        }
        if (object instanceof Signature) {
            return this.getActions((Signature)object, component);
        }
        if (object instanceof DefaultMutableTreeNode) {
            return this.getActions((DefaultMutableTreeNode)object, component);
        }
        if (object instanceof HierNode) {
            return this.getActions((HierNode)object, component);
        }
        System.out.println("Couldn't determine actions for a " + object.getClass().getName());
        return EmptyActionArray;
    }

    private Action[] getActions(OWL oWL, Component component) {
        Browser browser = Browser.forComponent(component);
        Action[] actionArray = browser == null ? new Action[]{new ViewTargetNewAction(oWL, browser)} : new Action[]{new ViewTargetAction(oWL, browser), new ViewTargetNewAction(oWL, browser)};
        return actionArray;
    }

    private Action[] getActions(Relation relation, Component component) {
        return this.getActions(relation.getRelation(), component);
    }

    private Action[] getActions(Signature signature, Component component) {
        return this.getActions(signature.getRelation(), component);
    }

    private Action[] getActions(HierNode hierNode, Component component) {
        return this.getActions(hierNode.getTerm(), component);
    }

    private Action[] getActions(DefaultMutableTreeNode defaultMutableTreeNode, Component component) {
        return this.getActions(defaultMutableTreeNode.getUserObject(), component);
    }
}

