/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.QManager;
import com.ow.util.OWUtil;
import java.io.Serializable;

public class IODEHTMLParser
implements Serializable {
    public static final String symTag = "sym";
    public static final String symTagBegin = "<sym>";
    public static final String symTagEnd = "</sym>";
    public static final String codeTagBegin = "<code>";
    public static final String codeTagEnd = "</code>";
    private static final int symTagBeginLength = symTagBegin.length();
    private static final int symTagEndLength = symTagEnd.length();
    public static final String dashChar = "&#151";
    private static final String dashStr = " -- ";
    private static final int dashCharLength = "&#151".length();
    Browser browser = null;
    QManager qmgr = null;
    private transient String curToken = null;

    public IODEHTMLParser(Browser browser) {
        this.browser = browser;
    }

    public IODEHTMLParser(QManager qManager) {
        this.qmgr = qManager;
    }

    public void setQManager(QManager qManager) {
        this.qmgr = qManager;
    }

    public QManager getQManager() {
        return this.browser != null ? this.browser.getQManager() : this.qmgr;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public static String markUpSymbols(OWL oWL) {
        if (oWL == null) {
            return null;
        }
        if (oWL instanceof Form) {
            return IODEHTMLParser.markUpSymbols0((Form)oWL);
        }
        if (oWL instanceof Symbol) {
            return IODEHTMLParser.markUpSymbols0((Symbol)oWL);
        }
        return oWL.toString();
    }

    private static String markUpSymbols0(Form form) {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(IODEHTMLParser.markUpSymbols(form.functor()));
        int n = 0;
        while (n < form.arity()) {
            stringBuffer.append(' ');
            stringBuffer.append(IODEHTMLParser.markUpSymbols(form.arg(n)));
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String markUpSymbols0(Symbol symbol) {
        return symbol.isReal() || symbol.isInt() ? codeTagBegin + symbol.toString() + codeTagEnd : symTagBegin + symbol.toString() + symTagEnd;
    }

    public String parse(String string, boolean bl) {
        return this.parse(string, bl, false);
    }

    public String parse(String string, boolean bl, boolean bl2) {
        return this.parse(string, bl, bl2, this.getQManager());
    }

    public String parse(String string, boolean bl, boolean bl2, QManager qManager) {
        this.qmgr = qManager;
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = this.indexToProcess(string, n)) != -1) {
            stringBuffer.append(string.substring(n, n2));
            if (this.curToken == symTagBegin) {
                Symbol symbol;
                n = n2 + symTagBeginLength;
                if ((n2 = string.indexOf(symTagEnd, n)) == -1) continue;
                String string2 = string.substring(n, n2);
                Symbol symbol2 = symbol = this.disambiguated(string2) ? new Symbol(string2) : this.disambiguate(string2, qManager);
                if (symbol == null) {
                    symbol = new Symbol("??." + string2);
                }
                boolean bl3 = false;
                if (bl2) {
                    stringBuffer.append(codeTagBegin);
                    boolean bl4 = bl3 = symbol.isInt() || symbol.isReal();
                    if (!bl3) {
                        stringBuffer.append("<a href=\"");
                        stringBuffer.append(symbol);
                        stringBuffer.append("\">");
                    }
                }
                stringBuffer.append(bl ? symbol.toString() : OWUtil.trimContext(symbol));
                if (bl2) {
                    if (!bl3) {
                        stringBuffer.append("</a>");
                    }
                    stringBuffer.append(codeTagEnd);
                }
                n = n2 + symTagEndLength;
                continue;
            }
            if (this.curToken != dashChar) continue;
            stringBuffer.append(dashStr);
            n = n2 + dashCharLength;
            if (string.charAt(n) != ';') continue;
            ++n;
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    private Symbol disambiguate(String string, QManager qManager) {
        return qManager == null ? new Symbol("??." + string) : qManager.disambiguate(string);
    }

    private boolean disambiguated(String string) {
        return string.indexOf(46) != -1;
    }

    private int indexToProcess(String string, int n) {
        int n2 = -1;
        n2 = this.considerToken(string, n, symTagBegin, n2);
        n2 = this.considerToken(string, n, dashChar, n2);
        return n2;
    }

    private int considerToken(String string, int n, String string2, int n2) {
        int n3 = string.indexOf(string2, n);
        if (n2 == -1 || n3 > -1 && n3 < n2) {
            n2 = n3;
            this.curToken = string2;
        }
        return n2;
    }
}

