/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.ow.gui.AdjVisCaret;
import com.ow.gui.OEditorPane;
import com.ow.gui.iode.ContextSuppressor;
import com.ow.gui.iode.IODE;
import com.ow.gui.iode.IODEHTMLParser;
import com.ow.gui.iode.QManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.text.Caret;

public class IODEHTMLPane
extends OEditorPane {
    static int maxPreferredWidth = 300;
    String realText;
    String showContextText;
    String hideContextText;
    IODEHTMLParser parser;
    QManager qmgr;

    public IODEHTMLPane() {
        this("", (QManager)null);
    }

    public IODEHTMLPane(String string, QManager qManager) {
        super("text/html", "");
        this.setCaret(new AdjVisCaret());
        this.setEditable(false);
        this.parser = new IODEHTMLParser(qManager);
        this.qmgr = qManager;
        this.addWiring();
        this.setText(string, qManager);
    }

    private void addWiring() {
        IODE.getPopupManager().manage(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }

    public void setText(String string) {
        this.setText(string, this.qmgr);
    }

    public void setText(String string, QManager qManager) {
        if (this.parser != null) {
            this.parser.setQManager(qManager);
        } else {
            this.parser = new IODEHTMLParser(qManager);
        }
        this.qmgr = qManager;
        this.realText = string;
        this.hideContextText = null;
        this.showContextText = null;
        this.setContextDisplayMode(ContextSuppressor.getMode(this), qManager);
    }

    public void setText(QuotedString quotedString, QManager qManager) {
        this.setText(quotedString.text(), qManager);
    }

    protected void setContextDisplayMode(boolean bl, QManager qManager) {
        String string;
        AdjVisCaret adjVisCaret;
        if (this.qmgr == null || !this.qmgr.equals(qManager)) {
            this.hideContextText = null;
            this.showContextText = null;
        }
        this.qmgr = qManager;
        Caret caret = this.getCaret();
        AdjVisCaret adjVisCaret2 = adjVisCaret = caret instanceof AdjVisCaret ? (AdjVisCaret)caret : null;
        if (adjVisCaret != null) {
            adjVisCaret.setVisibility(false);
        }
        String string2 = string = bl ? this.showContextText : this.hideContextText;
        if (string == null) {
            string = this.parser.parse(this.realText, bl, true, qManager);
        }
        if (bl) {
            this.showContextText = string;
        } else {
            this.hideContextText = string;
        }
        super.setText(string);
        if (adjVisCaret != null) {
            adjVisCaret.setVisibility(true);
        }
    }

    public String getText() {
        return this.realText;
    }

    public static String markUpSymbols(OWL oWL) {
        return IODEHTMLParser.markUpSymbols(oWL);
    }
}

