/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.gui.SplashPane;
import com.kb.kbddutil.KBProperties;
import com.kb.oms.OMSAPI;
import com.ow.gui.AWTExceptionHandler;
import com.ow.gui.GUtil;
import com.ow.gui.Workspace;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.IODEClassAutoLoader;
import com.ow.gui.iode.IODEFrame;
import com.ow.gui.iode.IODEGUI;
import com.ow.gui.iode.IODEPopupManager;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.QManagerPool;
import com.ow.gui.iode.config.BrowserConfig;
import java.io.InvalidClassException;
import javax.swing.UIManager;

public class IODE {
    public static final String omsProp = "database";
    public static final String omsDef = "oms";
    public static final String workspaceProp = "com.ow.iode.workspace";
    public static final String defaultWorkspaceFilename = "iode.ws";
    public static final String workspacePathname;
    static final boolean silentOnNewInstall = true;
    static final boolean silentOnGeneralException = true;
    static SplashPane splash;
    static final IODEPopupManager popupManager;
    public static final String fontNameProp = "iode.font.name";
    public static final String fontStyleProp = "iode.font.style";
    public static final String fontSizeProp = "iode.font.size";
    public static final String defaultFontName = "Arial";
    public static final String defaultFontStyle = "plain";
    public static final int defaultFontSize = 11;
    static Workspace workspace;
    static BrowserConfig browserConfig;
    static QManagerPool qmanagerPool;
    static /* synthetic */ Class class$com$ow$gui$iode$IODEThrowableDisplayer;

    private IODE() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setFont();
        IODEGUI.setDefaults();
        this.preloadSystem();
        workspace = new Workspace(workspacePathname);
        if (workspace.saved()) {
            try {
                workspace.restore();
                Object[] objectArray = workspace.getList();
                String string = null;
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof String) {
                        string = (String)objectArray[n];
                    } else if (objectArray[n] instanceof BrowserConfig) {
                        browserConfig = (BrowserConfig)objectArray[n];
                    } else if (objectArray[n] instanceof QManagerPool) {
                        qmanagerPool = (QManagerPool)objectArray[n];
                    }
                    ++n;
                }
                if (string == null) {
                    this.defaultDisplay();
                    return;
                }
                this.closeSplashIfNeeded();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof IODEFrame) {
                        ((IODEFrame)objectArray[n2]).show();
                    }
                    ++n2;
                }
                return;
            }
            catch (InvalidClassException invalidClassException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.defaultDisplay();
    }

    private void setFont() {
        String string = KBProperties.get(fontNameProp, defaultFontName);
        String string2 = KBProperties.get(fontStyleProp, defaultFontStyle);
        int n = KBProperties.get_int(fontSizeProp, 11);
        int n2 = GUtil.getFontStyleFlags(string2);
        GUtil.setUIFont(string, n2, n);
    }

    private void defaultDisplay() {
        System.out.println("using default workspace");
        browserConfig = new BrowserConfig();
        workspace.add(browserConfig);
        workspace.add(qmanagerPool);
        Browser browser = new Browser(IODE.getQManager((String)null));
        this.closeSplashIfNeeded();
        browser.show();
    }

    private void preloadSystem() {
        splash = new SplashPane();
        splash.show();
        new IODEClassAutoLoader().loadClasses();
    }

    private void closeSplashIfNeeded() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    public static Workspace getWorkspace() {
        return workspace;
    }

    public static BrowserConfig getBrowserConfig() {
        return browserConfig;
    }

    public static IODEPopupManager getPopupManager() {
        return popupManager;
    }

    public static QManager getQManager(String string) {
        return qmanagerPool.getQManager(new OMSAPI(string));
    }

    public static QManager getQManager(OMSAPI oMSAPI) {
        if (oMSAPI == null) {
            throw new IllegalArgumentException("omsapi must be non-null");
        }
        return qmanagerPool.getQManager(oMSAPI);
    }

    public static void exit() {
        browserConfig.dispose();
        qmanagerPool.closeAll();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting IODE...");
        new IODE();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        popupManager = new IODEPopupManager();
        AWTExceptionHandler.setAsHandler(class$com$ow$gui$iode$IODEThrowableDisplayer == null ? (class$com$ow$gui$iode$IODEThrowableDisplayer = IODE.class$("com.ow.gui.iode.IODEThrowableDisplayer")) : class$com$ow$gui$iode$IODEThrowableDisplayer);
        String string = KBProperties.installDir();
        string = string + System.getProperty("file.separator");
        String string2 = KBProperties.get(workspaceProp, defaultWorkspaceFilename);
        workspacePathname = string + string2;
        System.out.println("Workspace path: " + workspacePathname);
        qmanagerPool = new QManagerPool();
    }
}

