/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.module.DataModule;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class DisplayCache
implements Serializable {
    private static int CONTEXT = 0;
    private static int TARGET = 1;
    private static int QMGR = 2;
    HashMap componentMap = new HashMap();
    HashMap targetMap = new HashMap();

    public JComponent getComponent(DataModule dataModule) {
        return (JComponent)this.componentMap.get(dataModule);
    }

    public JComponent getDisplay(OWL oWL, OWL oWL2, QManager qManager, DataModule dataModule) {
        JComponent jComponent = (JComponent)this.componentMap.get(dataModule);
        if (jComponent == null) {
            return this.getNewComponent(oWL, oWL2, qManager, dataModule);
        }
        if (this.targetMatch(jComponent, oWL, oWL2, qManager)) {
            return jComponent;
        }
        jComponent = dataModule.refreshDisplay(jComponent, oWL, oWL2, qManager);
        this.addEntries(dataModule, jComponent, oWL, oWL2, qManager);
        return jComponent;
    }

    public JComponent refreshDisplay(OWL oWL, OWL oWL2, QManager qManager, DataModule dataModule) {
        JComponent jComponent = (JComponent)this.componentMap.get(dataModule);
        if (jComponent == null) {
            return this.getNewComponent(oWL, oWL2, qManager, dataModule);
        }
        jComponent = dataModule.refreshDisplay(jComponent, oWL, oWL2, qManager);
        this.addEntries(dataModule, jComponent, oWL, oWL2, qManager);
        return jComponent;
    }

    private JComponent getNewComponent(OWL oWL, OWL oWL2, QManager qManager, DataModule dataModule) {
        JComponent jComponent = dataModule.getDisplay(oWL, oWL2, qManager);
        this.addEntries(dataModule, jComponent, oWL, oWL2, qManager);
        return jComponent;
    }

    private boolean targetMatch(JComponent jComponent, OWL oWL, OWL oWL2, QManager qManager) {
        Object[] objectArray = (Object[])this.targetMap.get(jComponent);
        if (objectArray == null) {
            return false;
        }
        return this.equals(objectArray[CONTEXT], oWL) && this.equals(objectArray[TARGET], oWL2) && this.equals(objectArray[QMGR], qManager);
    }

    private boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void addEntries(DataModule dataModule, JComponent jComponent, OWL oWL, OWL oWL2, QManager qManager) {
        this.resetCaretIfApplicable(jComponent);
        Object[] objectArray = new Object[3];
        objectArray[DisplayCache.CONTEXT] = oWL;
        objectArray[DisplayCache.TARGET] = oWL2;
        objectArray[DisplayCache.QMGR] = qManager;
        this.componentMap.put(dataModule, jComponent);
        this.targetMap.put(jComponent, objectArray);
    }

    private void resetCaretIfApplicable(JComponent jComponent) {
        if (!(jComponent instanceof JTextComponent)) {
            return;
        }
    }
}

