/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.ow.gui.Desktop2;
import com.ow.gui.GUtil;
import com.ow.gui.OInternalFrame;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.DisplayCache;
import com.ow.gui.iode.IODE;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.IODEThrowableDisplayer;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.Target;
import com.ow.gui.iode.TargetOWL;
import com.ow.gui.iode.VBoxPanel;
import com.ow.gui.iode.VertBox;
import com.ow.gui.iode.config.BrowserConfig;
import com.ow.gui.iode.config.BrowserSettings;
import com.ow.gui.iode.module.DataModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DataArea
extends JPanel {
    public static final int DESKTOP = 500;
    public static final int TABBED_PANE = 501;
    public static final int VERTICAL_LAYOUT = 502;
    public static int DEFAULT_DISPLAY = 501;
    public static final String emptyText = "Enter a term or OWL sentence in the field above.<br>Examples:<ul><li> Property<li> MetricCtx.volt<li> (arity ?X ?Y)</ul>You can also search using * as a wildcard:<ul><li> *Rel<li> TopUserCtx.*<li> Root*Prop*</ul>";
    Target target;
    OWL currentType;
    Vector modules;
    Browser browser;
    JComponent activeDisplay;
    JEditorPane emptyHTMLPane;
    JEditorPane nonOWLHTMLPane;
    JComponent emptyPane;
    JComponent nonOWLPane;
    int displayMode;
    DisplayCache displayCache;
    String selectedTab;
    JScrollPane desktopScrPane;
    Desktop2 desktop;
    JTabbedPane tabbedPane;
    JScrollPane vertScrPane;
    VertBox vertBox;
    HashMap internalFrameMap;
    HashMap vertPaneMap;
    JScrollPane[] tabScrolls;
    int[] tabScrollSettings;

    public DataArea(Browser browser) {
        super(new BorderLayout());
        this.browser = browser;
        this.displayCache = new DisplayCache();
        this.modules = new Vector();
        this.internalFrameMap = new HashMap();
        this.vertPaneMap = new HashMap();
        this.initGUI();
        this.setDisplayMode(DEFAULT_DISPLAY);
        this.enableDebugContainers();
    }

    private void initGUI() {
        this.emptyHTMLPane = new IODEHTMLPane(emptyText, this.getQManager());
        this.nonOWLHTMLPane = new IODEHTMLPane(emptyText, this.getQManager());
        this.emptyPane = new JScrollPane(this.emptyHTMLPane);
        this.nonOWLPane = new JScrollPane(this.nonOWLHTMLPane);
        this.add("Center", this.emptyPane);
        this.activeDisplay = this.emptyPane;
        this.setPreferredSize(new Dimension(600, 400));
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    protected void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target getTarget() {
        return this.target;
    }

    public QManager getQManager() {
        return this.browser.getQManager();
    }

    public void setDisplayMode(int n) {
        this.rememberTabSettings();
        if (n == this.displayMode) {
            return;
        }
        if (n == 500) {
            this.viewAsDesktop();
        } else if (n == 501) {
            this.viewAsTabs();
        } else if (n == 502) {
            this.viewAsVerticalLayout();
        } else {
            throw new IllegalArgumentException("unrecognized display mode");
        }
    }

    private void rememberTabSettings() {
        if (this.displayMode != 501) {
            return;
        }
        if (this.tabbedPane == null) {
            this.selectedTab = null;
        } else {
            int n = this.tabbedPane.getSelectedIndex();
            this.selectedTab = n == -1 ? null : this.tabbedPane.getTitleAt(n);
            int n2 = 0;
            while (n2 < this.tabScrolls.length) {
                if (this.tabScrolls[n2] != null) {
                    this.tabScrollSettings[n2] = this.tabScrolls[n2].getVerticalScrollBar().getValue();
                }
                ++n2;
            }
        }
    }

    private void viewAsDesktop() {
        this.displayMode = 500;
        if (this.noTarget()) {
            return;
        }
        if (this.desktopScrPane == null) {
            this.desktop = new Desktop2();
            this.desktopScrPane = new JScrollPane(this.desktop);
        }
        Iterator iterator = ((AbstractList)this.modules).iterator();
        while (iterator.hasNext()) {
            DataModule dataModule = (DataModule)iterator.next();
            this.prepareInternalFrame(dataModule);
        }
        this.setDisplayTo(this.desktopScrPane);
    }

    private void viewAsTabs() {
        this.displayMode = 501;
        if (this.noTarget()) {
            return;
        }
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
        }
        this.tabbedPane.removeAll();
        Iterator iterator = ((AbstractList)this.modules).iterator();
        while (iterator.hasNext()) {
            DataModule dataModule = (DataModule)iterator.next();
            this.prepareTab(dataModule);
        }
        this.setDisplayTo(this.tabbedPane);
        this.selectTab();
        this.tabbedPane.getSelectedComponent().setVisible(true);
        this.tabbedPane.validate();
    }

    private void selectTab() {
        if (this.selectedTab == null) {
            this.tabbedPane.setSelectedIndex(0);
            return;
        }
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            if (this.selectedTab.equals(this.tabbedPane.getTitleAt(n))) {
                this.tabbedPane.setSelectedIndex(n);
                return;
            }
            ++n;
        }
        this.tabbedPane.setSelectedIndex(0);
    }

    private void viewAsVerticalLayout() {
        this.displayMode = 502;
        if (this.noTarget()) {
            return;
        }
        if (this.vertScrPane == null) {
            this.vertBox = new VertBox();
            this.vertScrPane = new JScrollPane(this.vertBox);
        }
        this.vertBox.removeAll();
        Iterator iterator = ((AbstractList)this.modules).iterator();
        while (iterator.hasNext()) {
            DataModule dataModule = (DataModule)iterator.next();
            this.prepareVPane(dataModule);
        }
        this.setDisplayTo(this.vertScrPane);
    }

    public void refresh() {
        this.rememberTabSettings();
        if (this.noTarget()) {
            this.setDisplayTo(this.emptyPane);
        } else if (!this.owlTarget()) {
            this.setDisplayTo(this.nonOWLPane);
        } else {
            this.checkForNewDisplayType();
            Iterator iterator = ((AbstractList)this.modules).iterator();
            while (iterator.hasNext()) {
                this.refreshDisplay((DataModule)iterator.next());
            }
            if (this.displayMode == 500) {
                this.viewAsDesktop();
            }
            if (this.displayMode == 501) {
                this.viewAsTabs();
            }
            if (this.displayMode == 502) {
                this.viewAsVerticalLayout();
            }
        }
    }

    private boolean noTarget() {
        return this.target == null || this.target.equals("");
    }

    private boolean owlTarget() {
        return this.target instanceof TargetOWL;
    }

    private void refreshDisplay(DataModule dataModule) {
        OWL oWL = ((TargetOWL)this.target).getOWL();
        JComponent jComponent = this.displayCache.getComponent(dataModule);
        JComponent jComponent2 = this.displayCache.refreshDisplay(null, oWL, this.browser.getQManager(), dataModule);
        if (jComponent != null && jComponent != jComponent2) {
            Container container = jComponent.getParent();
            if (container instanceof OInternalFrame) {
                ((OInternalFrame)container).setContentPane(jComponent2);
            } else if (container == this.tabbedPane) {
                int n = this.tabbedPane.indexOfComponent(jComponent);
                this.tabbedPane.remove(n);
                this.tabbedPane.add(jComponent2, dataModule.getTitle(), n);
            } else if (container instanceof JPanel) {
                JPanel jPanel = (JPanel)container;
                jPanel.removeAll();
                jPanel.add("Center", jComponent2);
            }
        }
    }

    private void checkForNewDisplayType() {
        OWL oWL;
        BrowserConfig browserConfig = IODE.browserConfig;
        BrowserSettings browserSettings = browserConfig.getSettings();
        DataModule[][] dataModuleArray = browserSettings.getModules(oWL = ((TargetOWL)this.target).getOWL(), this.browser);
        Object[] objectArray = dataModuleArray[0];
        if (!this.equal(this.modules, objectArray)) {
            this.clearAllDisplayModes();
            this.modules = new Vector();
            int n = 0;
            while (n < objectArray.length) {
                this.modules.add(objectArray[n]);
                ++n;
            }
            this.displayCache = new DisplayCache();
            this.tabScrolls = new JScrollPane[objectArray.length];
            this.tabScrollSettings = new int[objectArray.length];
        }
    }

    private boolean equal(Vector vector, Object[] objectArray) {
        if (vector.size() != objectArray.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!vector.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void clearAllDisplayModes() {
        this.desktop = null;
        if (this.tabbedPane != null) {
            this.tabbedPane.removeAll();
        }
        this.vertScrPane = null;
    }

    private void setDisplayTo(Component component) {
        if (!this.isAncestorOf(component)) {
            this.setVisible(false);
            this.removeAll();
            this.add("Center", component);
            this.setVisible(true);
        }
        if (component == this.nonOWLPane) {
            this.nonOWLHTMLPane.setText(this.target.getHTMLText());
        }
        this.validate();
    }

    private void prepareInternalFrame(DataModule dataModule) {
        OInternalFrame oInternalFrame = (OInternalFrame)this.internalFrameMap.get(dataModule);
        boolean bl = false;
        if (oInternalFrame == null) {
            oInternalFrame = new OInternalFrame(dataModule.getTitle(), true, false, true, true);
            this.internalFrameMap.put(dataModule, oInternalFrame);
            this.desktop.add(oInternalFrame, null);
            bl = true;
            oInternalFrame.setContentPane(new JScrollPane());
        }
        JScrollPane jScrollPane = (JScrollPane)oInternalFrame.getContentPane();
        OWL oWL = ((TargetOWL)this.target).getOWL();
        jScrollPane.setViewportView(this.displayCache.getDisplay(null, oWL, this.browser.getQManager(), dataModule));
        if (bl) {
            GUtil.minPack(oInternalFrame);
            oInternalFrame.show();
        }
    }

    private void prepareTab(DataModule dataModule) {
        OWL oWL = ((TargetOWL)this.target).getOWL();
        JComponent jComponent = this.displayCache.getDisplay(null, oWL, this.browser.getQManager(), dataModule);
        JComponent jComponent2 = this.maybeAddScroll(jComponent);
        this.tabbedPane.add((Component)jComponent2, dataModule.getTitle());
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.indexOfComponent(jComponent2), dataModule.getToolTipText());
    }

    private JComponent maybeAddScroll(JComponent jComponent) {
        int n = this.tabbedPane.getTabCount();
        JComponent jComponent2 = null;
        if (this.needsScroll(jComponent)) {
            JScrollPane jScrollPane = new JScrollPane(jComponent);
            this.setVerticalScroll(jScrollPane, this.tabScrollSettings[n]);
            this.tabScrollSettings[n] = jScrollPane.getVerticalScrollBar().getValue();
            this.tabScrolls[n] = jScrollPane;
            jComponent2 = jScrollPane;
        } else {
            this.tabScrollSettings[n] = 0;
            this.tabScrolls[n] = null;
            jComponent2 = jComponent;
        }
        return jComponent2;
    }

    private void setVerticalScroll(JScrollPane jScrollPane, final int n) {
        final JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollBar.setValue(n);
            }
        });
    }

    private void reportScrolls() {
        if (this.tabScrolls == null) {
            System.out.println("no tabscrolls yet");
            return;
        }
        System.out.print("tab scrolls: " + this.tabScrolls.length + "    ");
        int n = 0;
        while (n < this.tabScrolls.length) {
            if (this.tabScrolls[n] == null) {
                System.out.print("--  ");
            } else {
                System.out.print(this.tabScrollSettings[n] + "  ");
            }
            ++n;
        }
        System.out.println();
    }

    private boolean needsScroll(Component component) {
        Component[] componentArray;
        Container container;
        if (!(component instanceof JComponent)) {
            return false;
        }
        if (component instanceof JScrollPane) {
            return false;
        }
        if (component instanceof JSplitPane) {
            container = (JSplitPane)component;
            componentArray = ((JSplitPane)container).getLeftComponent();
            Component component2 = ((JSplitPane)container).getRightComponent();
            if (((JSplitPane)container).getOrientation() == 1) {
                return this.needsScroll((Component)componentArray) || this.needsScroll(component2);
            }
        }
        if (component instanceof Container) {
            container = (Container)component;
            componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JScrollPane && this.spansContainer(componentArray[n], container)) {
                    return false;
                }
                if (componentArray[n] instanceof Container && this.spansContainer(componentArray[n], container) && !this.needsScroll(componentArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean spansContainer(Component component, Container container) {
        int n;
        int n2 = container.getWidth();
        if (!container.isValid() || n2 == 0) {
            container.setSize(800, 200);
            container.doLayout();
            n2 = container.getWidth();
        }
        boolean bl = (n = component.getWidth()) == n2;
        return bl;
    }

    private void prepareVPane(DataModule dataModule) {
        VBoxPanel vBoxPanel = (VBoxPanel)this.vertPaneMap.get(dataModule);
        if (vBoxPanel == null) {
            vBoxPanel = new VBoxPanel();
            vBoxPanel.setBorder(BorderFactory.createTitledBorder(dataModule.getTitle()));
        }
        OWL oWL = ((TargetOWL)this.target).getOWL();
        vBoxPanel.add(this.displayCache.getDisplay(null, oWL, this.browser.getQManager(), dataModule));
        this.vertBox.add(vBoxPanel);
    }

    private void enableDebugContainers() {
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataArea.this.debugContainerHierarchy();
            }
        }, GUtil.getKeyStroke("casH"), 2);
    }

    private void debugContainerHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeHier(this, stringBuffer, 0);
        new IODEThrowableDisplayer().handle(stringBuffer.toString());
    }

    private void writeHier(Component component, StringBuffer stringBuffer, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  ");
            ++n2;
        }
        stringBuffer.append("c: " + component.getClass().getName());
        stringBuffer.append('\n');
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                this.writeHier(componentArray[n3], stringBuffer, n + 1);
                ++n3;
            }
        }
    }
}

