/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.logic.Formula;
import com.kb.oms.OMSAPI;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.ow.gui.iode.Browser;
import com.ow.gui.iode.ContextSuppressible;
import com.ow.gui.iode.IODE;
import com.ow.gui.iode.IODEHTMLPane;
import com.ow.gui.iode.IODEHTMLParser;
import com.ow.gui.iode.IODETree;
import com.ow.gui.iode.OWLRepresentable;
import com.ow.gui.iode.QManager;
import com.ow.util.OWUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContextSuppressor
extends JCheckBox {
    public static final String TitleOn = "contexts on";
    public static final String TitleOff = "contexts off";
    public static final boolean defaultMode = false;
    private static final IODEHTMLParser defaultParser = new IODEHTMLParser((QManager)null);
    boolean mode;
    JFrame frame;
    IODEHTMLParser parser;

    public ContextSuppressor(JFrame jFrame, OMSAPI oMSAPI) {
        this(jFrame, false, IODE.getQManager(oMSAPI));
    }

    public ContextSuppressor(JFrame jFrame, QManager qManager) {
        this(jFrame, false, qManager);
    }

    public ContextSuppressor(JFrame jFrame, boolean bl, OMSAPI oMSAPI) {
        this(jFrame, bl, IODE.getQManager(oMSAPI));
    }

    public ContextSuppressor(JFrame jFrame, boolean bl, QManager qManager) {
        super(TitleOn);
        this.setFrame(jFrame);
        this.mode = bl;
        this.parser = new IODEHTMLParser(qManager);
        this.setToolTipText("Toggle context display");
        this.addWiring();
    }

    public ContextSuppressor(Browser browser) {
        this(browser, false);
    }

    public ContextSuppressor(Browser browser, boolean bl) {
        super(TitleOn);
        this.mode = bl;
        this.parser = new IODEHTMLParser(browser);
        this.setFrame(browser);
        this.setToolTipText("Toggle context display");
        this.addWiring();
    }

    private void addWiring() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContextSuppressor.this.toggleMode();
            }
        });
    }

    public static boolean getMode(Component component) {
        if (component == null) {
            return false;
        }
        if (component instanceof Browser) {
            return ((Browser)component).areContextsShown();
        }
        if (component instanceof Window) {
            return component instanceof ContextSuppressible ? ((ContextSuppressible)((Object)component)).getContextSuppressor().getMode() : false;
        }
        return ContextSuppressor.getMode(SwingUtilities.getWindowAncestor(component));
    }

    public static String getText(Object object, Component component) {
        if (object instanceof Form || object instanceof Symbol || object instanceof Formula) {
            return ContextSuppressor.getMode(component) ? object.toString() : OWUtil.trimContext(object);
        }
        if (object instanceof OWLRepresentable) {
            OWL oWL = ((OWLRepresentable)object).getOWLRepresentation();
            return oWL == null ? ContextSuppressor.getText(object.toString(), component) : ContextSuppressor.getText(oWL, component);
        }
        if (object instanceof DefaultMutableTreeNode) {
            return ContextSuppressor.getText(((DefaultMutableTreeNode)object).getUserObject(), component);
        }
        if (object instanceof String) {
            return ContextSuppressor.getParser(component).parse((String)object, ContextSuppressor.getMode(component), component instanceof JEditorPane);
        }
        return ContextSuppressor.getParser(component).parse(object.toString(), ContextSuppressor.getMode(component), false);
    }

    private static IODEHTMLParser getParser(Component component) {
        IODEHTMLParser iODEHTMLParser = ContextSuppressor.getParser0(component);
        if (iODEHTMLParser == null) {
            iODEHTMLParser = defaultParser;
        }
        return iODEHTMLParser;
    }

    private static IODEHTMLParser getParser0(Component component) {
        if (component == null) {
            return defaultParser;
        }
        if (component instanceof Browser) {
            return ((Browser)component).getContextSuppressor().parser;
        }
        if (component instanceof Window) {
            return component instanceof ContextSuppressible ? ((ContextSuppressible)((Object)component)).getContextSuppressor().parser : defaultParser;
        }
        return ContextSuppressor.getParser0(SwingUtilities.getWindowAncestor(component));
    }

    public boolean getMode() {
        return this.mode;
    }

    public void setFrame(JFrame jFrame) {
        if (jFrame == null) {
            throw new IllegalArgumentException("frame must be non-null");
        }
        this.frame = jFrame;
        if (jFrame instanceof Browser) {
            this.parser.setBrowser((Browser)jFrame);
        }
    }

    public static String markUpContexts(OWL oWL) {
        if (oWL instanceof IVar) {
            return "<font size=-1>" + oWL.toString() + "</font>";
        }
        if (oWL instanceof Symbol) {
            Symbol symbol = (Symbol)oWL;
            String string = OWUtil.getContextName(symbol);
            return string == null ? symbol.toString() : "<font color=gray>" + string + ".</font>" + OWUtil.trimContext(symbol);
        }
        if (oWL instanceof Form) {
            Form form = (Form)oWL;
            StringBuffer stringBuffer = new StringBuffer("(");
            stringBuffer.append(ContextSuppressor.markUpContexts(form.functor()));
            int n = 0;
            while (n < form.arity()) {
                stringBuffer.append(' ');
                stringBuffer.append(ContextSuppressor.markUpContexts(form.arg(n)));
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return oWL.toString();
    }

    private void toggleMode() {
        boolean bl = this.mode = !this.mode;
        if (this.frame instanceof Browser) {
            ((Browser)this.frame).refreshTitle();
        }
        this.toggleMode(this.frame.getContentPane(), 0);
        this.frame.repaint();
    }

    private void toggleMode(Component component, int n) {
        if (component instanceof IODETree) {
            ((IODETree)component).setContextDisplayMode(this.mode);
        }
        if (component instanceof IODEHTMLPane) {
            ((IODEHTMLPane)component).setContextDisplayMode(this.mode, this.getQManager());
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                this.toggleMode(componentArray[n2], n + 1);
                ++n2;
            }
        }
    }

    private QManager getQManager() {
        if (this.frame instanceof Browser) {
            return ((Browser)this.frame).getQManager();
        }
        return this.parser.getQManager();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addWiring();
    }
}

