/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.kbddutil.KBProperties;
import com.ow.gui.iode.Target;
import java.io.Serializable;

public class BrowserHistory
implements Serializable {
    public static final String historyProp = "com.ow.iode.browserHistory";
    public static final int historyPropDef = 50;
    Target[] historyList;
    int earliest;
    int latest;
    int current;

    public BrowserHistory() {
        this(KBProperties.get_int(historyProp, 50));
    }

    public BrowserHistory(int n) {
        this.historyList = new Target[n];
        this.current = -1;
        this.latest = -1;
        this.earliest = -1;
    }

    public void removeAll() {
        this.current = -1;
        this.latest = -1;
        this.earliest = -1;
    }

    public Target getCurrent() {
        return this.current < 0 ? null : this.historyList[this.current];
    }

    public void addNewTarget(Target target) {
        if (this.current == -1) {
            this.historyList[0] = target;
            this.current = 0;
            this.latest = 0;
            this.earliest = 0;
        } else {
            this.current = this.increment(this.current);
            this.historyList[this.current] = target;
            this.latest = this.current;
            if (this.earliest == this.latest) {
                this.earliest = this.increment(this.earliest);
            }
        }
    }

    public Target moveBackward() {
        if (this.current == this.earliest) {
            return this.current == -1 ? null : this.historyList[this.current];
        }
        this.current = this.decrement(this.current);
        return this.historyList[this.current];
    }

    public Target moveForward() {
        if (this.current == this.latest) {
            return this.current == -1 ? null : this.historyList[this.current];
        }
        this.current = this.increment(this.current);
        return this.historyList[this.current];
    }

    private int increment(int n) {
        if (++n == this.historyList.length) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n == -1) {
            n = this.historyList.length - 1;
        }
        return n;
    }
}

