/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui.iode;

import com.kb.owl.OWL;
import com.ow.gui.GUtil;
import com.ow.gui.iode.BrowserHistory;
import com.ow.gui.iode.ContextSuppressible;
import com.ow.gui.iode.ContextSuppressor;
import com.ow.gui.iode.DataArea;
import com.ow.gui.iode.IODEFrame;
import com.ow.gui.iode.QManager;
import com.ow.gui.iode.SymbolsNotFoundException;
import com.ow.gui.iode.Target;
import com.ow.gui.iode.TargetBadSymbols;
import com.ow.gui.iode.TargetIndicator;
import com.ow.gui.iode.TargetOWL;
import com.ow.gui.iode.action.ClearCacheAction;
import com.ow.gui.iode.action.HistBackAction;
import com.ow.gui.iode.action.HistForwardAction;
import com.ow.gui.iode.action.ReloadAction;
import com.ow.gui.iode.action.ViewAsTabsAction;
import com.ow.gui.iode.action.ViewAsVLayoutAction;
import com.ow.gui.iode.config.BrowserConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Browser
extends IODEFrame
implements ContextSuppressible {
    public static final String noTargetTitle = "[no target]";
    protected static Stack targetCompletionList = new Stack();
    ContextSuppressor contextSup;
    TargetIndicator targetInd;
    DataArea dataArea;
    Target curTarget;
    BrowserHistory history;
    QManager qmgr;
    private boolean initedGUI = false;
    final Runnable setCursorBack = new Runnable(){

        public void run() {
            Browser.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    };
    static /* synthetic */ Class class$com$ow$gui$iode$Browser;

    private Browser() {
        super(noTargetTitle);
    }

    public Browser(QManager qManager) {
        super(noTargetTitle);
        this.setQManager(qManager);
    }

    public Browser(OWL oWL, Browser browser) {
        super(noTargetTitle);
        if (browser == null) {
            throw new IllegalArgumentException("browser must be non-null");
        }
        this.setQManager(browser.getQManager());
        this.initGUI();
        this.history = new BrowserHistory();
        this.setTarget(oWL);
        Rectangle rectangle = browser.getBounds();
        GUtil.smartTranslate(rectangle, GUtil.newWindowPosInc);
        ((Component)this).setBounds(rectangle);
    }

    private void initGUI() {
        this.contextSup = new ContextSuppressor(this);
        this.targetInd = new TargetIndicator(this);
        this.dataArea = new DataArea(this);
        this.initMenuBar();
        this.contextSup.setMnemonic('c');
        this.layoutComponents();
        this.pack();
    }

    private void initMenuBar() {
        JMenu jMenu = GUtil.createJMenu('B', "Browser");
        JMenu jMenu2 = GUtil.createJMenu('V', "View As");
        GUtil.createMI(jMenu2, "a1", 't', new ViewAsTabsAction(this.dataArea));
        GUtil.createMI(jMenu2, "a2", 'v', new ViewAsVLayoutAction(this.dataArea));
        jMenu.add(jMenu2);
        GUtil.createMI(jMenu, "aLeft", 'b', new HistBackAction(this));
        GUtil.createMI(jMenu, "aRight", 'f', new HistForwardAction(this));
        GUtil.createMI(jMenu, "cR", 'r', new ReloadAction(this));
        GUtil.createMI(jMenu, 'q', (Action)new ClearCacheAction(this));
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            jMenuBar = new JMenuBar();
            this.setJMenuBar(jMenuBar);
        }
        jMenuBar.add(jMenu);
    }

    private void layoutComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", GUtil.createMnemLabel("Target: ", "t", this.targetInd));
        jPanel.add("East", this.contextSup);
        jPanel.add("Center", this.targetInd);
        this.dataArea.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        Container container = this.getContentPane();
        container.add("Center", this.dataArea);
        container.add("North", jPanel);
        this.initedGUI = true;
    }

    public void show() {
        if (!this.initedGUI) {
            this.initGUI();
            GUtil.center(this);
            this.history = new BrowserHistory();
        }
        super.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Browser.this.targetInd.requestFocus();
            }
        });
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.qmgr);
        objectOutput.writeObject(this.contextSup);
        objectOutput.writeObject(this.targetInd);
        objectOutput.writeObject(this.dataArea);
        objectOutput.writeObject(this.curTarget);
        objectOutput.writeObject(this.history);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.qmgr = (QManager)objectInput.readObject();
        this.contextSup = (ContextSuppressor)objectInput.readObject();
        this.targetInd = (TargetIndicator)objectInput.readObject();
        this.dataArea = (DataArea)objectInput.readObject();
        this.curTarget = (Target)objectInput.readObject();
        this.history = (BrowserHistory)objectInput.readObject();
        this.contextSup.setFrame(this);
        this.targetInd.setBrowser(this);
        this.dataArea.setBrowser(this);
        this.initedGUI = true;
        this.layoutComponents();
        this.initMenuBar();
    }

    public ContextSuppressor getContextSuppressor() {
        return this.contextSup;
    }

    public static Browser forComponent(Component component) {
        Browser browser = component instanceof Browser ? (Browser)component : (Browser)SwingUtilities.getAncestorOfClass(class$com$ow$gui$iode$Browser == null ? (class$com$ow$gui$iode$Browser = Browser.class$("com.ow.gui.iode.Browser")) : class$com$ow$gui$iode$Browser, component);
        return browser;
    }

    public void refresh() {
        if (this.noTarget()) {
            this.clear();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.refreshTitle();
        if (this.curTarget != null && !(this.curTarget instanceof TargetBadSymbols)) {
            this.targetInd.setTarget(this.curTarget);
        }
        this.dataArea.setTarget(this.curTarget);
        this.dataArea.setVisible(false);
        this.dataArea.refresh();
        this.dataArea.setVisible(true);
        SwingUtilities.invokeLater(this.setCursorBack);
    }

    private boolean noTarget() {
        return this.curTarget == null;
    }

    public void setTarget(OWL oWL) {
        this.setTarget(oWL == null ? null : new TargetOWL(oWL));
    }

    public void setTarget(Target target) {
        if (target == null) {
            this.clear();
            return;
        }
        if (target.equals(this.curTarget)) {
            return;
        }
        if (target instanceof TargetOWL) {
            OWL oWL = ((TargetOWL)target).getOWL();
            try {
                this.curTarget = new TargetOWL(this.qmgr.disambiguate(oWL));
            }
            catch (SymbolsNotFoundException symbolsNotFoundException) {
                this.curTarget = new TargetBadSymbols(symbolsNotFoundException);
            }
        } else {
            this.curTarget = target;
        }
        if (!(this.curTarget instanceof TargetBadSymbols)) {
            this.history.addNewTarget(this.curTarget);
        }
        this.refresh();
    }

    public boolean areContextsShown() {
        return this.contextSup.getMode();
    }

    public Target getTarget() {
        return this.curTarget;
    }

    public void clear() {
        this.curTarget = null;
        this.refreshTitle();
        this.dataArea.setTarget(null);
        this.dataArea.refresh();
    }

    public void refreshTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.noTarget()) {
            stringBuffer.append(noTargetTitle);
        } else if (this.curTarget instanceof TargetBadSymbols) {
            stringBuffer.append("--");
        } else {
            stringBuffer.append(ContextSuppressor.getText(this.curTarget, this));
        }
        stringBuffer.append(" @");
        stringBuffer.append(this.qmgr.getDatabaseName());
        stringBuffer.append(" - IODE Browser");
        this.setTitle(stringBuffer.toString());
    }

    public Object getSelection() {
        System.out.println("getSelection() called");
        return null;
    }

    public void applyConfiguration(BrowserConfig browserConfig) {
        System.out.println("applyConfiguration() called");
    }

    public void setQManager(QManager qManager) {
        boolean bl = qManager != this.qmgr;
        this.qmgr = qManager;
        if (this.curTarget != null) {
            this.refresh();
        } else if (bl) {
            this.refreshTitle();
        }
    }

    public QManager getQManager() {
        return this.qmgr;
    }

    public void historyBackward() {
        Target target = this.history.moveBackward();
        if (target != null && target.equals(this.curTarget)) {
            return;
        }
        this.curTarget = target;
        this.refresh();
    }

    public void historyForward() {
        Target target = this.history.moveForward();
        if (target != null && target.equals(this.curTarget)) {
            return;
        }
        this.curTarget = target;
        this.refresh();
    }

    protected void newContext(OWL oWL) {
    }

    protected void newTarget(Target target) {
        System.out.println("new target selected: " + target);
        this.setTarget(target);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

