/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Workspace {
    File file;
    Vector objects;

    public Workspace(String string) {
        this(new File(string));
    }

    public Workspace(File file) {
        this.file = file;
    }

    public void add(Serializable serializable) {
        if (this.objects == null) {
            this.objects = new Vector();
        }
        if (this.objects.contains(serializable)) {
            return;
        }
        this.objects.add(serializable);
    }

    public void remove(Serializable serializable) {
        if (this.objects == null) {
            return;
        }
        this.objects.remove(serializable);
    }

    public Object[] getList() {
        return this.objects.toArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save() throws InvalidClassException, NotSerializableException, IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.file));
                objectOutputStream.writeObject(this.objects);
                objectOutputStream.flush();
            }
            catch (NotSerializableException notSerializableException) {
                objectOutputStream.close();
                objectOutputStream = null;
                this.file.delete();
                throw notSerializableException;
            }
            Object var4_2 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (objectOutputStream == null) throw throwable;
            objectOutputStream.close();
            throw throwable;
        }
        objectOutputStream.close();
    }

    public boolean saved() {
        return this.file.exists() && this.file.canRead();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restore() throws OptionalDataException, ClassNotFoundException, IOException {
        boolean bl = true;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(this.file));
            this.objects = (Vector)objectInputStream.readObject();
            Object var4_3 = null;
            if (objectInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (objectInputStream == null) throw throwable;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
    }

    public void showAllWindows() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Iterator iterator = ((AbstractList)Workspace.this.objects).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Window)) continue;
                    ((Window)e).show();
                }
            }
        });
    }
}

