/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;

public class Typematic
implements ActionListener {
    private static int defaultExpire = 1000;
    private static String[] commands = new String[95];
    private static final int minCode = 32;
    private static final int maxCode = 126;
    int expire;
    long lastTime;
    boolean firstChar;
    String currentSeq;
    JComponent component;

    public Typematic(JComponent jComponent) {
        this(jComponent, defaultExpire);
    }

    public Typematic(JComponent jComponent, int n) {
        int n2 = 32;
        while (n2 <= 126) {
            char c = (char)n2;
            String string = commands[n2 - 32];
            jComponent.registerKeyboardAction(this, string, KeyStroke.getKeyStroke(c), 0);
            ++n2;
        }
        this.component = jComponent;
        this.expire = n;
        this.lastTime = 0L;
        this.firstChar = true;
        this.currentSeq = new String();
    }

    public static int getDefaultExpire() {
        return defaultExpire;
    }

    public static void setDefaultExpire(int n) {
        defaultExpire = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processChar(actionEvent.getActionCommand().charAt(0));
    }

    private void processChar(char c) {
        long l = System.currentTimeMillis();
        int n = (int)(l - this.lastTime);
        this.lastTime = l;
        if (n >= this.expire || this.firstChar) {
            this.startNewSeq(c);
        } else {
            this.continueSeq(c);
        }
        this.firstChar = false;
    }

    private void startNewSeq(char c) {
        char[] cArray = new char[]{c};
        this.currentSeq = new String(cArray);
        this.searchForMatch();
    }

    private void continueSeq(char c) {
        if (this.getCurrentIndex() == -1) {
            return;
        }
        String string = this.currentSeq + c;
        if (this.getItemString(this.getCurrentIndex()).startsWith(string)) {
            this.currentSeq = string;
        } else if (this.currentSeq.length() == 0 || this.currentSeq.charAt(this.currentSeq.length() - 1) == c) {
            this.startNewSeq(c);
        } else {
            this.currentSeq = string;
            this.searchForMatch();
        }
    }

    private void searchForMatch() {
        int n = this.getLastIndex();
        if (n == -1) {
            return;
        }
        int n2 = this.getCurrentIndex() + 1;
        if (n2 > n) {
            n2 = 0;
        }
        int n3 = n2;
        boolean bl = false;
        do {
            if ((bl = this.getItemString(n2).startsWith(this.currentSeq)) || ++n2 <= n) continue;
            n2 = 0;
        } while (n2 != n3 && !bl);
        if (bl) {
            this.setSelectedIndex(n2);
        }
    }

    private int getCurrentIndex() {
        int n = -1;
        if (this.component instanceof JList) {
            n = ((JList)this.component).getSelectedIndex();
        } else if (this.component instanceof JTree) {
            int[] nArray = ((JTree)this.component).getSelectionRows();
            n = nArray == null ? -1 : nArray[0];
        }
        return n;
    }

    private int getLastIndex() {
        int n = -1;
        if (this.component instanceof JList) {
            ListModel listModel = ((JList)this.component).getModel();
            n = listModel.getSize() - 1;
        } else if (this.component instanceof JTree) {
            n = ((JTree)this.component).getRowCount() - 1;
        }
        return n;
    }

    private String getItemString(int n) {
        Object object;
        Object object2 = null;
        if (this.component instanceof JList) {
            object = ((JList)this.component).getModel();
            object2 = object.getElementAt(n);
        } else if (this.component instanceof JTree) {
            object = (JTree)this.component;
            object2 = ((JTree)object).getPathForRow(n).getLastPathComponent();
        }
        object = null;
        if (object2 != null) {
            object = object2.toString().toLowerCase();
        }
        return object;
    }

    private void setSelectedIndex(int n) {
        if (this.component instanceof JList) {
            JList jList = (JList)this.component;
            jList.setSelectedIndex(n);
            jList.ensureIndexIsVisible(n);
        } else if (this.component instanceof JTree) {
            JTree jTree = (JTree)this.component;
            jTree.setSelectionRow(n);
            jTree.scrollRowToVisible(n);
        }
    }

    static {
        char[] cArray = new char[1];
        int n = 32;
        while (n <= 126) {
            cArray[0] = (char)n;
            Typematic.commands[n - 32] = new String(cArray).toLowerCase();
            ++n;
        }
    }
}

