/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.ow.gui.AmbidexLinkListener;
import com.ow.gui.GUtil;
import com.ow.gui.LinkedSentence;
import com.ow.gui.OEditorPane;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.StringReader;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;

public class SentenceView
extends OEditorPane {
    public static final String HTML = "text/html";
    LinkedSentence model;
    boolean indented;
    static SentenceView sv1 = new SentenceView();
    static SentenceView sv2 = new SentenceView();
    static JTextField tf = new JTextField();
    static JFrame frame = new JFrame("SentenceView Demo");
    static JCheckBox check = new JCheckBox(" indented", false);

    public SentenceView() {
        this("");
    }

    public SentenceView(String string) {
        this(string, false);
    }

    public SentenceView(String string, boolean bl) {
        super(HTML, "");
        this.model = new LinkedSentence(string, bl);
        this.indented = bl;
        this.getPreferredSize();
        this.setEditable(false);
        this.setText(this.model.getText());
    }

    public SentenceView(Form form) {
        this(form, false);
    }

    public SentenceView(Form form, boolean bl) {
        super(HTML, "");
        this.model = new LinkedSentence(form, bl);
        this.indented = bl;
        this.getPreferredSize();
        this.setEditable(false);
        this.setText(this.model.getText());
    }

    public void setSentence(String string) {
        this.model.setSentence(string);
        this.setText(this.model.getText());
    }

    public void setSentence(Form form) {
        this.model.setSentence(form);
        this.setText(this.model.getText());
    }

    public Form getSentence() {
        return this.model.getSentence();
    }

    public boolean isIndented() {
        return this.model.isIndented();
    }

    public void setIndented(boolean bl) {
        if (bl == this.indented) {
            return;
        }
        this.indented = bl;
        this.model.setIndented(bl);
        this.setText(this.model.getText());
    }

    private void explore1() {
        this.model.explore1();
    }

    public static void main(String[] stringArray) {
        frame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = GUtil.createMnemLabel("Enter a OWL sentence and press Enter.", "E", tf);
        check.setMnemonic('i');
        jPanel.add(jLabel);
        jPanel.add(tf);
        jPanel.add(check);
        jPanel.add(new JLabel("passed as a string:"));
        jPanel.add(sv1);
        jPanel.add(new JLabel("passed as a form:"));
        jPanel.add(sv2);
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SentenceView.main1(tf.getText());
            }
        });
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sv1.setIndented(check.isSelected());
                sv2.setIndented(check.isSelected());
                frame.pack();
            }
        });
        new DefaultAmbidexLinkListener(sv1);
        new DefaultAmbidexLinkListener(sv2);
        frame.setContentPane(jPanel);
        frame.pack();
        sv1.getPreferredSize();
        sv2.getPreferredSize();
        frame.pack();
        frame.show();
    }

    private static void main1(String string) {
        Container container = frame.getContentPane();
        System.out.println("Sentence is '" + string + '\'');
        sv1.setSentence(string);
        OWL oWL = null;
        try {
            oWL = new OWLParser(new StringReader(string)).readExpr();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (!(oWL instanceof Form)) {
            oWL = null;
        }
        sv2.setSentence((Form)oWL);
        sv1.explore1();
        sv2.explore1();
        ((JPanel)container).revalidate();
        container.repaint();
        frame.pack();
        System.out.println();
    }

    static class DefaultAmbidexLinkListener
    extends AmbidexLinkListener {
        public DefaultAmbidexLinkListener(JEditorPane jEditorPane) {
            super(jEditorPane);
        }

        public void hyperlinkEntered(HyperlinkEvent hyperlinkEvent) {
            System.out.println("hyperlinkEntered: " + this.str(hyperlinkEvent));
        }

        public void hyperlinkExited(HyperlinkEvent hyperlinkEvent) {
            System.out.println("hyperlinkExited: " + this.str(hyperlinkEvent));
        }

        public void hyperlinkLeftClicked(HyperlinkEvent hyperlinkEvent, int n, int n2) {
            System.out.println("hyperlinkLeftClicked: " + this.str(hyperlinkEvent, n, n2));
        }

        public void hyperlinkRightClicked(HyperlinkEvent hyperlinkEvent, int n, int n2) {
            System.out.println("hyperlinkRightClicked: " + this.str(hyperlinkEvent, n, n2));
        }

        public void paneLeftClicked(MouseEvent mouseEvent) {
            System.out.println("paneLeftClicked: " + this.str(mouseEvent));
        }

        public void paneRightClicked(MouseEvent mouseEvent) {
            System.out.println("paneRightClicked: " + this.str(mouseEvent));
        }

        private String str(HyperlinkEvent hyperlinkEvent) {
            return "u=" + hyperlinkEvent.getURL() + " d=" + hyperlinkEvent.getDescription();
        }

        private String str(HyperlinkEvent hyperlinkEvent, int n, int n2) {
            return "u=" + hyperlinkEvent.getURL() + " d=" + hyperlinkEvent.getDescription() + " x=" + n + " y=" + n2;
        }

        private String str(MouseEvent mouseEvent) {
            return "(" + mouseEvent.getX() + ',' + mouseEvent.getY() + ')';
        }
    }
}

